/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.annotations.ImportModule;
import org.apache.tapestry5.ioc.annotations.SubModule;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.def.ModuleDef2;
import org.apache.tapestry5.ioc.internal.DefaultModuleDefImpl;
import org.apache.tapestry5.ioc.internal.LoggerSourceImpl;
import org.apache.tapestry5.ioc.internal.PerThreadOperationTracker;
import org.apache.tapestry5.ioc.internal.RegistryImpl;
import org.apache.tapestry5.ioc.internal.RegistryWrapper;
import org.apache.tapestry5.ioc.internal.services.PlasticProxyFactoryImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.modules.TapestryIOCModule;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.slf4j.Logger;

public final class RegistryBuilder {
    private final OneShotLock lock = new OneShotLock();
    final List<ModuleDef2> modules = CollectionFactory.newList();
    private final ClassLoader classLoader;
    private final Logger logger;
    private final LoggerSource loggerSource;
    private final PlasticProxyFactory proxyFactory;
    private final Set<Class> addedModuleClasses = CollectionFactory.newSet();

    public RegistryBuilder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public RegistryBuilder(ClassLoader classLoader) {
        this(classLoader, new LoggerSourceImpl());
    }

    public RegistryBuilder(ClassLoader classLoader, LoggerSource loggerSource) {
        this.classLoader = classLoader;
        this.loggerSource = loggerSource;
        this.logger = loggerSource.getLogger(RegistryBuilder.class);
        Logger proxyFactoryLogger = loggerSource.getLogger(TapestryIOCModule.class.getName() + ".PlasticProxyFactory");
        this.proxyFactory = new PlasticProxyFactoryImpl(this.classLoader, proxyFactoryLogger);
        this.add(TapestryIOCModule.class);
    }

    public RegistryBuilder add(ModuleDef moduleDef) {
        this.lock.check();
        this.modules.add(InternalUtils.toModuleDef2(moduleDef));
        return this;
    }

    public RegistryBuilder add(Class ... moduleClasses) {
        this.lock.check();
        List queue = CollectionFactory.newList(Arrays.asList(moduleClasses));
        while (!queue.isEmpty()) {
            ImportModule importModule;
            Class c = (Class)queue.remove(0);
            if (this.addedModuleClasses.contains(c)) continue;
            this.addedModuleClasses.add(c);
            this.logger.info("Adding module definition for " + c);
            DefaultModuleDefImpl def = new DefaultModuleDefImpl(c, this.logger, this.proxyFactory);
            this.add(def);
            Class element = c;
            SubModule subModule = element.getAnnotation(SubModule.class);
            if (subModule != null) {
                queue.addAll(Arrays.asList(subModule.value()));
            }
            if ((importModule = element.getAnnotation(ImportModule.class)) == null) continue;
            queue.addAll(Arrays.asList(importModule.value()));
        }
        return this;
    }

    public RegistryBuilder add(String classname) {
        this.lock.check();
        try {
            Class<?> builderClass = Class.forName(classname, true, this.classLoader);
            this.add(builderClass);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failure loading Tapestry IoC module class %s: %s", classname, ExceptionUtils.toMessage((Throwable)ex), ex));
        }
        return this;
    }

    public Registry build() {
        this.lock.lock();
        PerThreadOperationTracker tracker = new PerThreadOperationTracker(this.loggerSource.getLogger(Registry.class));
        RegistryImpl registry = new RegistryImpl(this.modules, this.proxyFactory, this.loggerSource, tracker);
        return new RegistryWrapper(registry);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static Registry buildAndStartupRegistry(ModuleDef moduleDef, Class ... moduleClasses) {
        RegistryBuilder builder = new RegistryBuilder();
        if (moduleDef != null) {
            builder.add(moduleDef);
        }
        builder.add(moduleClasses);
        Registry registry = builder.build();
        registry.performRegistryStartup();
        return registry;
    }

    public static Registry buildAndStartupRegistry(Class ... moduleClasses) {
        return RegistryBuilder.buildAndStartupRegistry(null, moduleClasses);
    }
}

