// Copyright 2008 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry5.integration.app4.pages;

import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ComponentClassResolver;

public class Start
{
    @InjectPage
    private Destination destination;
    
    @Inject
    private ComponentClassResolver componentClassResolver;

    private String input;
    
    
    public boolean getIndexPageExists()
    {
        return componentClassResolver.isPageName("Index");
    }
    
    public boolean getStartPageExists()
    {
        return componentClassResolver.isPageName("Start");
    }

    public String getInput()
    {
        return input;
    }

    public void setInput(String input)
    {
        this.input = input;
    }

    Object onSuccess()
    {
        destination.setValue(input);

        return destination;
    }

    Object onActionFromBypass()
    {
        destination.setValue("automatic value");

        return destination;
    }
}
