// Copyright 2008, 2011 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry5.integration.app4;

import org.apache.tapestry5.integration.TapestryCoreTestCase;
import org.testng.annotations.Test;

/**
 * Tests for immediate mode (aka T4 mode, aka
 * {@linkplain org.apache.tapestry5.SymbolConstants#SUPPRESS_REDIRECT_FROM_ACTION_REQUESTS
 * redirects suppressed} mode).
 */
public class ImmediateModeTests extends TapestryCoreTestCase
{
    @Test
    public void action_link()
    {
        openLinks("here");

        assertTextSeries("//dd[%d]", 1, "onActivate() invoked", "automatic value");

        clickAndWait("link=refresh page");

        assertTextSeries("//dd[%d]", 1, "onActivate(String) invoked - onActivate() invoked",
                "automatic value");

        clickAndWait("link=refresh via action");

        // The last onActivate() is due to the "default" rendering of the page for the action link
        // (on the same page).

        assertTextSeries("//dd[%d]", 1,
                "onActivate(String) invoked - onActivate() invoked - onActivate() invoked",
                "automatic value");
    }

    @Test
    public void form_submission()
    {
        openBaseURL();

        type("input", "immediate mode");

        clickAndWait(SUBMIT);

        assertTextSeries("//dd[%d]", 1, "onActivate() invoked", "immediate mode");

        clickAndWait("link=refresh page");

        assertTextSeries("//dd[%d]", 1, "onActivate(String) invoked - onActivate() invoked",
                "immediate mode");

        clickAndWait("link=refresh via action");

        // The last onActivate() is due to the "default" rendering of the page for the action link
        // (on the same page).

        assertTextSeries("//dd[%d]", 1,
                "onActivate(String) invoked - onActivate() invoked - onActivate() invoked",
                "immediate mode");

    }
    
    /** TAP5-1086 */
    @Test
    public void localized_root_path_no_index_page()
    {
       openBaseURL();
       assertTextPresent("Start Page");
       
       // This test relies on the fact that no 'Index' page is available 
       // Following checks ensure that a refactoring (rename of Start to Index) breaks the test
       assertTextPresent("Index Page Exists: false");
       assertTextPresent("Start Page Exists: true");
       
       open(getBaseURL()+"en");
       assertTextPresent("Start Page");
       
       open(getBaseURL()+"start");
       assertTextPresent("Start Page");
       
       open(getBaseURL()+"start/en");
       assertTextPresent("Start Page");
       
       open(getBaseURL()+"index");
       assertTextPresent("Start Page");
       
       open(getBaseURL()+"index/en");
       assertTextPresent("Start Page");
    }

}
