// Copyright 2006, 2007, 2008 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry5.services;

import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.MarkupWriter;

/**
 * Source for {@link org.apache.tapestry5.MarkupWriter} instances.
 */
public interface MarkupWriterFactory
{
    /**
     * Creates a markup writer for a particular content type.
     *
     * @param contentType type of content generated by the markup write; used to control the type of {@link
     *                    org.apache.tapestry5.dom.MarkupModel} used with the {@link org.apache.tapestry5.dom.Document}
     *                    the backs the markup writer.
     */
    MarkupWriter newMarkupWriter(ContentType contentType);

    /**
     * Creates a markup writer for a particular content type, configured for <em>partial page rendering</em> (i.e., for
     * a response to an Ajax request).
     *
     * @param contentType type of content generated by the markup write; used to control the type of {@link
     *                    org.apache.tapestry5.dom.MarkupModel} used with the {@link org.apache.tapestry5.dom.Document}
     *                    the backs the markup writer.
     */
    MarkupWriter newPartialMarkupWriter(ContentType contentType);

    /**
     * Obtains a markup writer that will render the content for the provided logical page name.
     *
     * @param pageName logical page name
     * @return writer configured for the page
     */
    MarkupWriter newMarkupWriter(String pageName);
}
