/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Install {
    public static final String DEFAULT_DISTRIBUTION_PATH = "wrapper/dists";
    private final IDownload download;
    private final PathAssembler pathAssembler;

    public Install(IDownload iDownload, PathAssembler pathAssembler) {
        this.download = iDownload;
        this.pathAssembler = pathAssembler;
    }

    public File createDist(WrapperConfiguration wrapperConfiguration) throws Exception {
        File file;
        URI uRI = wrapperConfiguration.getDistribution();
        boolean bl = wrapperConfiguration.isAlwaysDownload();
        boolean bl2 = wrapperConfiguration.isAlwaysUnpack();
        PathAssembler.LocalDistribution localDistribution = this.pathAssembler.getDistribution(wrapperConfiguration);
        File file2 = localDistribution.getZipFile();
        boolean bl3 = false;
        if (bl || !file2.exists()) {
            file = new File(file2.getParentFile(), file2.getName() + ".part");
            file.delete();
            System.out.println("Downloading " + uRI);
            this.download.download(uRI, file);
            file.renameTo(file2);
            bl3 = true;
        }
        file = localDistribution.getDistributionDir();
        List<File> list = this.listDirs(file);
        if (bl3 || bl2 || list.isEmpty()) {
            for (File file3 : list) {
                System.out.println("Deleting directory " + file3.getAbsolutePath());
                this.deleteDir(file3);
            }
            System.out.println("Unzipping " + file2.getAbsolutePath() + " to " + file.getAbsolutePath());
            this.unzip(file2, file);
            list = this.listDirs(file);
            if (list.isEmpty()) {
                throw new RuntimeException(String.format("Gradle distribution '%s' does not contain any directories. Expected to find exactly 1 directory.", uRI));
            }
            this.setExecutablePermissions(list.get(0));
        }
        if (list.size() != 1) {
            throw new RuntimeException(String.format("Gradle distribution '%s' contains too many directories. Expected to find exactly 1 directory.", uRI));
        }
        return list.get(0);
    }

    private List<File> listDirs(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.exists()) {
            for (File file2 : file.listFiles()) {
                if (!file2.isDirectory()) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    private void setExecutablePermissions(File file) {
        if (this.isWindows()) {
            return;
        }
        File file2 = new File(file, "bin/gradle");
        String string = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("chmod", "755", file2.getCanonicalPath());
            Process process = processBuilder.start();
            if (process.waitFor() == 0) {
                System.out.println("Set executable permissions for: " + file2.getAbsolutePath());
            } else {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                Formatter formatter = new Formatter();
                while ((string2 = bufferedReader.readLine()) != null) {
                    formatter.format("%s%n", string2);
                }
                string = formatter.toString();
            }
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        catch (InterruptedException interruptedException) {
            string = interruptedException.getMessage();
        }
        if (string != null) {
            System.out.println("Could not set executable permissions for: " + file2.getAbsolutePath());
            System.out.println("Please do this manually if you want to use the Gradle UI.");
        }
    }

    private boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase(Locale.US);
        return string.indexOf("windows") > -1;
    }

    private boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = this.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public void unzip(File file, File file2) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) {
                new File(file2, zipEntry.getName()).mkdirs();
                continue;
            }
            this.copyInputStream(zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(new File(file2, zipEntry.getName()))));
        }
        zipFile.close();
    }

    public void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }
}

