/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.hibernate;

import java.io.Serializable;
import org.apache.tapestry5.annotations.ImmutableSessionPersistedObject;
import org.apache.tapestry5.internal.hibernate.HibernateMessages;
import org.hibernate.Session;

@ImmutableSessionPersistedObject
public class PersistedEntity
implements Serializable {
    private static final long serialVersionUID = 897120520279686518L;
    private final String entityName;
    private final Serializable id;

    public PersistedEntity(String entityName, Serializable id) {
        this.entityName = entityName;
        this.id = id;
    }

    public Object restore(Session session) {
        try {
            return session.get(this.entityName, this.id);
        }
        catch (Exception ex) {
            throw new RuntimeException(HibernateMessages.sessionPersistedEntityLoadFailure(this.entityName, this.id, ex));
        }
    }

    public String toString() {
        return String.format("<PersistedEntity: %s(%s)>", this.entityName, this.id);
    }
}

