/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.hibernate;

import java.io.Serializable;
import org.apache.tapestry5.internal.hibernate.PersistedEntity;
import org.apache.tapestry5.internal.services.SessionApplicationStatePersistenceStrategy;
import org.apache.tapestry5.services.ApplicationStateCreator;
import org.apache.tapestry5.services.Request;
import org.hibernate.HibernateException;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityApplicationStatePersistenceStrategy
extends SessionApplicationStatePersistenceStrategy {
    private final Session hibernateSession;

    public EntityApplicationStatePersistenceStrategy(Request request, Session hibernateSession) {
        super(request);
        this.hibernateSession = hibernateSession;
    }

    public <T> T get(Class<T> ssoClass, ApplicationStateCreator<T> creator) {
        Object persistedValue = this.getOrCreate(ssoClass, creator);
        if (persistedValue instanceof PersistedEntity) {
            PersistedEntity persisted = (PersistedEntity)persistedValue;
            Object restored = persisted.restore(this.hibernateSession);
            if (restored == null) {
                this.set(ssoClass, null);
                return (T)this.getOrCreate(ssoClass, creator);
            }
            return (T)restored;
        }
        return (T)persistedValue;
    }

    public <T> void set(Class<T> ssoClass, T sso) {
        Object entity;
        String key = this.buildKey(ssoClass);
        if (sso != null) {
            try {
                String entityName = this.hibernateSession.getEntityName(sso);
                Serializable id = this.hibernateSession.getIdentifier(sso);
                entity = new PersistedEntity(entityName, id);
            }
            catch (HibernateException ex) {
                entity = sso;
            }
        } else {
            entity = sso;
        }
        this.getSession().setAttribute(key, entity);
    }
}

