/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.hibernate.pages;

import java.util.Collection;
import org.apache.tapestry5.annotations.ContentType;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.WhitelistAccessOnly;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.hibernate.Session;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ContentType(value="text/html")
@WhitelistAccessOnly
public class Statistics {
    @Inject
    private Session session;
    @Property
    @Inject
    @Symbol(value="tapestry.production-mode")
    private boolean productionMode;
    @Property
    private String currentEntityName;
    @Property
    private String currentCollectionRoleName;
    @Property
    private String currentQuery;
    @Property
    private String currentSecondLevelCacheRegionName;
    @Property
    private org.hibernate.stat.Statistics statistics;

    void onActivate() {
        this.statistics = this.session.getSessionFactory().getStatistics();
    }

    public Collection<ClassMetadata> getAllClassMetadata() {
        return this.session.getSessionFactory().getAllClassMetadata().values();
    }

    public EntityStatistics getEntityStatistics() {
        return this.statistics.getEntityStatistics(this.currentEntityName);
    }

    public CollectionStatistics getCollectionStatistics() {
        return this.statistics.getCollectionStatistics(this.currentCollectionRoleName);
    }

    public QueryStatistics getQueryStatistics() {
        return this.statistics.getQueryStatistics(this.currentQuery);
    }

    public SecondLevelCacheStatistics getSecondLevelCacheStatistics() {
        return this.statistics.getSecondLevelCacheStatistics(this.currentSecondLevelCacheRegionName);
    }
}

