/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.services.Response;

public class TextStreamResponse
implements StreamResponse {
    private final ContentType contentType;
    private final String text;

    public TextStreamResponse(String contentType, String text) {
        this(contentType, "UTF-8", text);
    }

    public TextStreamResponse(String contentType, String charset, String text) {
        this(new ContentType(contentType, charset), text);
    }

    public TextStreamResponse(ContentType contentType, String text) {
        assert (contentType != null);
        assert (text != null);
        this.contentType = contentType;
        this.text = text;
    }

    public String getContentType() {
        return this.contentType.toString();
    }

    public InputStream getStream() throws IOException {
        byte[] textBytes = this.text.getBytes(this.contentType.getCharset());
        return new ByteArrayInputStream(textBytes);
    }

    public void prepareResponse(Response response) {
    }
}

