/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.util;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Mac;
import org.apache.commons.codec.binary.Base64;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class MacOutputStream
extends OutputStream {
    private final Mac mac;

    public static MacOutputStream streamFor(Key key) throws IOException {
        try {
            Mac mac = Mac.getInstance(key.getAlgorithm());
            mac.init(key);
            return new MacOutputStream(mac);
        }
        catch (Exception ex) {
            throw new IOException("Unable to create MacOutputStream: " + InternalUtils.toMessage((Throwable)ex));
        }
    }

    public MacOutputStream(Mac mac) {
        assert (mac != null);
        this.mac = mac;
    }

    public String getResult() {
        byte[] result = this.mac.doFinal();
        return new String(Base64.encodeBase64((byte[])result));
    }

    public void write(int b) throws IOException {
        this.mac.update((byte)b);
    }

    public void write(byte[] b) throws IOException {
        this.mac.update(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.mac.update(b, off, len);
    }
}

