/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.lang.reflect.Modifier;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnclaimedFieldWorker
implements ComponentClassTransformWorker2 {
    private final PerthreadManager perThreadManager;
    private final ComponentClassCache classCache;

    public UnclaimedFieldWorker(ComponentClassCache classCache, PerthreadManager perThreadManager) {
        this.classCache = classCache;
        this.perThreadManager = perThreadManager;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getUnclaimedFields()) {
            this.transformField(field);
        }
    }

    private void transformField(PlasticField field) {
        if (Modifier.isFinal(field.getModifiers())) {
            return;
        }
        ComputedValue<FieldConduit<Object>> computed = this.createComputedFieldConduit(field);
        field.setComputedConduit(computed);
    }

    private ComputedValue<FieldConduit<Object>> createComputedFieldConduit(PlasticField field) {
        final String fieldType = field.getTypeName();
        return new ComputedValue<FieldConduit<Object>>(){

            public FieldConduit<Object> get(InstanceContext context) {
                Object fieldDefaultValue = UnclaimedFieldWorker.this.classCache.defaultValueForType(fieldType);
                InternalComponentResources resources = (InternalComponentResources)context.get(InternalComponentResources.class);
                return new UnclaimedFieldConduit(resources, UnclaimedFieldWorker.this.perThreadManager.createValue(), fieldDefaultValue);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnclaimedFieldConduit
    implements FieldConduit<Object> {
        private final InternalComponentResources resources;
        private final PerThreadValue<Object> fieldValue;
        private Object fieldDefaultValue;

        private UnclaimedFieldConduit(InternalComponentResources resources, PerThreadValue<Object> fieldValue, Object fieldDefaultValue) {
            this.resources = resources;
            this.fieldValue = fieldValue;
            this.fieldDefaultValue = fieldDefaultValue;
        }

        public Object get(Object instance, InstanceContext context) {
            return this.fieldValue.get(this.fieldDefaultValue);
        }

        public void set(Object instance, InstanceContext context, Object newValue) {
            this.fieldValue.set(newValue);
            if (!this.resources.isLoaded()) {
                this.fieldDefaultValue = newValue;
            }
        }
    }
}

