/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.List;
import org.apache.tapestry5.annotations.PageActivationContext;
import org.apache.tapestry5.internal.transform.TransformMessages;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.FieldHandle;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.runtime.ComponentEvent;
import org.apache.tapestry5.services.ComponentEventHandler;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class PageActivationContextWorker
implements ComponentClassTransformWorker2 {
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        List fields = plasticClass.getFieldsWithAnnotation(PageActivationContext.class);
        switch (fields.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.transformField(support, (PlasticField)fields.get(0));
                break;
            }
            default: {
                throw new RuntimeException(TransformMessages.illegalNumberOfPageActivationContextHandlers2(fields));
            }
        }
    }

    private void transformField(TransformationSupport support, PlasticField field) {
        PageActivationContext annotation = (PageActivationContext)field.getAnnotation(PageActivationContext.class);
        FieldHandle handle = field.getHandle();
        if (annotation.activate()) {
            support.addEventHandler("activate", 1, "PageActivationContextWorker activate event handler", PageActivationContextWorker.createActivationHandler(field.getTypeName(), handle));
        }
        if (annotation.passivate()) {
            support.addEventHandler("passivate", 0, "PageActivationContextWorker passivate event handler", PageActivationContextWorker.createPassivateHandler(handle));
        }
    }

    private static ComponentEventHandler createActivationHandler(final String fieldType, final FieldHandle handle) {
        return new ComponentEventHandler(){

            public void handleEvent(Component instance, ComponentEvent event) {
                Object value = event.coerceContext(0, fieldType);
                handle.set((Object)instance, value);
            }
        };
    }

    private static ComponentEventHandler createPassivateHandler(final FieldHandle handle) {
        return new ComponentEventHandler(){

            public void handleEvent(Component instance, ComponentEvent event) {
                Object value = handle.get((Object)instance);
                event.storeResult(value);
            }
        };
    }
}

