/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.annotations.HeartbeatDeferred;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.services.Heartbeat;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class HeartbeatDeferredWorker
implements ComponentClassTransformWorker2 {
    private final Heartbeat heartbeat;
    private final MethodAdvice deferredAdvice = new MethodAdvice(){

        public void advise(final MethodInvocation invocation) {
            HeartbeatDeferredWorker.this.heartbeat.defer(new Runnable(){

                public void run() {
                    invocation.proceed();
                }
            });
        }
    };

    public HeartbeatDeferredWorker(Heartbeat heartbeat) {
        this.heartbeat = heartbeat;
    }

    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticMethod method : plasticClass.getMethodsWithAnnotation(HeartbeatDeferred.class)) {
            this.deferMethodInvocations(method);
        }
    }

    void deferMethodInvocations(PlasticMethod method) {
        this.validateVoid(method);
        this.validateNoCheckedExceptions(method);
        method.addAdvice(this.deferredAdvice);
    }

    private void validateNoCheckedExceptions(PlasticMethod method) {
        if (method.getDescription().checkedExceptionTypes.length > 0) {
            throw new RuntimeException(String.format("Method %s is not compatible with the @HeartbeatDeferred annotation, as it throws checked exceptions.", method.getMethodIdentifier()));
        }
    }

    private void validateVoid(PlasticMethod method) {
        if (!method.isVoid()) {
            throw new RuntimeException(String.format("Method %s is not compatible with the @HeartbeatDeferred annotation, as it is not a void method.", method.getMethodIdentifier()));
        }
    }
}

