/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.structure;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.internal.services.LinkSource;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.ComponentPageElementResources;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ContextValueEncoder;
import org.apache.tapestry5.services.messages.ComponentMessagesSource;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPageElementResourcesImpl
implements ComponentPageElementResources {
    private final ComponentResourceSelector selector;
    private final ComponentMessagesSource componentMessagesSource;
    private final TypeCoercer typeCoercer;
    private final ComponentClassCache componentClassCache;
    private final ContextValueEncoder contextValueEncoder;
    private final LinkSource linkSource;
    private final RequestPageCache requestPageCache;
    private final ComponentClassResolver componentClassResolver;
    private final LoggerSource loggerSource;
    private final OperationTracker tracker;
    private final PerthreadManager perThreadManager;

    public ComponentPageElementResourcesImpl(ComponentResourceSelector selector, ComponentMessagesSource componentMessagesSource, TypeCoercer typeCoercer, ComponentClassCache componentClassCache, ContextValueEncoder contextValueEncoder, LinkSource linkSource, RequestPageCache requestPageCache, ComponentClassResolver componentClassResolver, LoggerSource loggerSource, OperationTracker tracker, PerthreadManager perThreadManager) {
        this.selector = selector;
        this.componentMessagesSource = componentMessagesSource;
        this.typeCoercer = typeCoercer;
        this.componentClassCache = componentClassCache;
        this.contextValueEncoder = contextValueEncoder;
        this.linkSource = linkSource;
        this.requestPageCache = requestPageCache;
        this.componentClassResolver = componentClassResolver;
        this.loggerSource = loggerSource;
        this.tracker = tracker;
        this.perThreadManager = perThreadManager;
    }

    @Override
    public ComponentResourceSelector getSelector() {
        return this.selector;
    }

    @Override
    public Messages getMessages(ComponentModel componentModel) {
        return this.componentMessagesSource.getMessages(componentModel, this.selector);
    }

    @Override
    public <S, T> T coerce(S input, Class<T> targetType) {
        return (T)this.typeCoercer.coerce(input, targetType);
    }

    @Override
    public Class toClass(String className) {
        return this.componentClassCache.forName(className);
    }

    @Override
    public Link createComponentEventLink(ComponentResources resources, String eventType, boolean forForm, Object ... context) {
        Page page = this.requestPageCache.get(resources.getPageName());
        return this.linkSource.createComponentEventLink(page, resources.getNestedId(), eventType, forForm, this.defaulted(context));
    }

    @Override
    public Link createPageRenderLink(String pageName, boolean override, Object ... context) {
        return this.linkSource.createPageRenderLink(pageName, override, this.defaulted(context));
    }

    @Override
    public Link createPageRenderLink(Class pageClass, boolean override, Object ... context) {
        assert (pageClass != null);
        String pageName = this.componentClassResolver.resolvePageClassNameToPageName(pageClass.getName());
        return this.linkSource.createPageRenderLink(pageName, override, this.defaulted(context));
    }

    @Override
    public Logger getEventLogger(Logger componentLogger) {
        String name = "tapestry.events." + componentLogger.getName();
        return this.loggerSource.getLogger(name);
    }

    @Override
    public String toClient(Object value) {
        return this.contextValueEncoder.toClient(value);
    }

    @Override
    public <T> T toValue(Class<T> requiredType, String clientValue) {
        return this.contextValueEncoder.toValue(requiredType, clientValue);
    }

    private Object[] defaulted(Object[] context) {
        return context == null ? InternalConstants.EMPTY_STRING_ARRAY : context;
    }

    public <T> T invoke(String description, Invokable<T> operation) {
        return (T)this.tracker.invoke(description, operation);
    }

    public void run(String description, Runnable operation) {
        this.tracker.run(description, operation);
    }

    @Override
    public <T> PerThreadValue<T> createPerThreadValue() {
        return this.perThreadManager.createValue();
    }
}

