/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.javascript;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.StylesheetLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreJavaScriptStack
implements JavaScriptStack {
    private final boolean productionMode;
    private final SymbolSource symbolSource;
    private final AssetSource assetSource;
    private final ThreadLocale threadLocale;
    private final List<Asset> javaScriptStack;
    private final List<Asset> stylesheetStack;
    private static final String ROOT = "org/apache/tapestry5";
    private static final String[] CORE_JAVASCRIPT = new String[]{"${tapestry.underscore}", "${tapestry.scriptaculous}/prototype.js", "${tapestry.scriptaculous}/scriptaculous.js", "${tapestry.scriptaculous}/effects.js", "org/apache/tapestry5/t5-core.js", "org/apache/tapestry5/t5-spi.js", "org/apache/tapestry5/t5-prototype.js", "org/apache/tapestry5/t5-init.js", "org/apache/tapestry5/t5-pubsub.js", "org/apache/tapestry5/t5-events.js", "org/apache/tapestry5/t5-dom.js", "org/apache/tapestry5/t5-console.js", "org/apache/tapestry5/t5-ajax.js", "org/apache/tapestry5/t5-formfragment.js", "org/apache/tapestry5/t5-alerts.js", "org/apache/tapestry5/tapestry.js", "org/apache/tapestry5/tapestry-console.js", "org/apache/tapestry5/tree.js"};
    private static final String[] CORE_STYLESHEET = new String[]{"org/apache/tapestry5/tapestry-console.css", "org/apache/tapestry5/t5-alerts.css", "org/apache/tapestry5/tree.css"};

    public CoreJavaScriptStack(@Symbol(value="tapestry.production-mode") boolean productionMode, SymbolSource symbolSource, AssetSource assetSource, ThreadLocale threadLocale) {
        this.symbolSource = symbolSource;
        this.productionMode = productionMode;
        this.assetSource = assetSource;
        this.threadLocale = threadLocale;
        this.javaScriptStack = this.convertToAssets(CORE_JAVASCRIPT);
        this.stylesheetStack = this.convertToAssets(CORE_STYLESHEET);
    }

    @Override
    public String getInitialization() {
        return this.productionMode ? null : "Tapestry.DEBUG_ENABLED = true;";
    }

    @Override
    public List<String> getStacks() {
        return Collections.emptyList();
    }

    private List<Asset> convertToAssets(String[] paths) {
        List assets = CollectionFactory.newList();
        for (String path : paths) {
            assets.add(this.expand(path, null));
        }
        return Collections.unmodifiableList(assets);
    }

    private Asset expand(String path, Locale locale) {
        String expanded = this.symbolSource.expandSymbols(path);
        return this.assetSource.getAsset(null, expanded, locale);
    }

    @Override
    public List<Asset> getJavaScriptLibraries() {
        Asset messages = this.assetSource.getAsset(null, "org/apache/tapestry5/tapestry-messages.js", this.threadLocale.getLocale());
        return this.createStack(this.javaScriptStack, messages).toList();
    }

    @Override
    public List<StylesheetLink> getStylesheets() {
        return this.createStack(this.stylesheetStack, new Asset[0]).map(TapestryInternalUtils.assetToStylesheetLink).toList();
    }

    private Flow<Asset> createStack(List<Asset> stack, Asset ... assets) {
        return F.flow(stack).append((Object[])assets);
    }
}

