/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.StreamableResource;

public class StreamableResourceImpl
implements StreamableResource {
    private final String description;
    private final String contentType;
    private final CompressionStatus compression;
    private final long lastModified;
    private final BytestreamCache bytestreamCache;

    public StreamableResourceImpl(String description, String contentType, CompressionStatus compression, long lastModified, BytestreamCache bytestreamCache) {
        this.description = description;
        this.contentType = contentType;
        this.compression = compression;
        this.lastModified = lastModified;
        this.bytestreamCache = bytestreamCache;
    }

    public String getDescription() {
        return this.description;
    }

    public CompressionStatus getCompression() {
        return this.compression;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getSize() {
        return this.bytestreamCache.size();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void streamTo(OutputStream os) throws IOException {
        this.bytestreamCache.writeTo(os);
    }

    public InputStream openStream() throws IOException {
        return this.bytestreamCache.openStream();
    }

    public String toString() {
        return String.format("StreamableResource<%s %s %s lastModified: %tc size: %d>", this.contentType, this.description, this.compression.name(), this.lastModified, this.getSize());
    }
}

