/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import org.apache.tapestry5.internal.services.AssetResourceLocator;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.services.assets.AssetRequestHandler;

public class ClasspathAssetRequestHandler
implements AssetRequestHandler {
    private final ResourceStreamer streamer;
    private final AssetResourceLocator assetResourceLocator;
    private final String baseFolder;

    public ClasspathAssetRequestHandler(ResourceStreamer streamer, AssetResourceLocator assetResourceLocator, String baseFolder) {
        this.streamer = streamer;
        this.assetResourceLocator = assetResourceLocator;
        this.baseFolder = baseFolder;
    }

    public boolean handleAssetRequest(Request request, Response response, String extraPath) throws IOException {
        String assetPath = this.baseFolder + "/" + extraPath;
        Resource resource = this.assetResourceLocator.findClasspathResourceForPath(assetPath);
        if (resource == null) {
            return false;
        }
        this.streamer.streamResource(resource);
        return true;
    }
}

