/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tapestry5.internal.services.ClusteredSessionImpl;
import org.apache.tapestry5.internal.services.SessionImpl;
import org.apache.tapestry5.internal.services.TapestrySessionFactory;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.Session;
import org.apache.tapestry5.services.SessionPersistedObjectAnalyzer;

public class TapestrySessionFactoryImpl
implements TapestrySessionFactory {
    private boolean clustered;
    private final SessionPersistedObjectAnalyzer analyzer;
    private final HttpServletRequest request;

    public TapestrySessionFactoryImpl(@Symbol(value="tapestry.clustered-sessions") boolean clustered, SessionPersistedObjectAnalyzer analyzer, HttpServletRequest request) {
        this.clustered = clustered;
        this.analyzer = analyzer;
        this.request = request;
    }

    public Session getSession(boolean create) {
        HttpSession httpSession = this.request.getSession(create);
        if (httpSession == null) {
            return null;
        }
        if (this.clustered) {
            return new ClusteredSessionImpl(this.request, httpSession, this.analyzer);
        }
        return new SessionImpl(this.request, httpSession);
    }
}

