/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ResponseCompressionAnalyzer;
import org.apache.tapestry5.services.assets.CompressionAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseCompressionAnalyzerImpl
implements ResponseCompressionAnalyzer {
    private final HttpServletRequest request;
    private final boolean gzipCompressionEnabled;
    private final CompressionAnalyzer analyzer;

    public ResponseCompressionAnalyzerImpl(HttpServletRequest request, CompressionAnalyzer analyzer, @Deprecated Collection<String> configuration, @Symbol(value="tapestry.gzip-compression-enabled") boolean gzipCompressionEnabled) {
        this.request = request;
        this.analyzer = analyzer;
        this.gzipCompressionEnabled = gzipCompressionEnabled;
    }

    @Override
    public boolean isGZipSupported() {
        if (!this.gzipCompressionEnabled) {
            return false;
        }
        if (this.request.getProtocol() == "HTTP/1.0") {
            return false;
        }
        String supportedEncodings = this.request.getHeader("Accept-Encoding");
        if (supportedEncodings == null) {
            return false;
        }
        for (String encoding : TapestryInternalUtils.splitAtCommas(supportedEncodings)) {
            if (!encoding.equalsIgnoreCase("gzip")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCompressable(String contentType) {
        return this.analyzer.isCompressable(contentType);
    }
}

