/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.net.URL;
import java.util.Map;
import org.apache.tapestry5.internal.services.ResourceDigestManager;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.InvalidationListener;
import org.apache.tapestry5.services.ResourceDigestGenerator;

public class ResourceDigestManagerImpl
implements ResourceDigestManager,
InvalidationListener {
    private final ResourceDigestGenerator digestGenerator;
    private final ResourceChangeTracker resourceChangeTracker;
    private final Map<Resource, Cached> cache = CollectionFactory.newConcurrentMap();
    static final long MISSING_RESOURCE_TIME_MODIFIED = -1L;

    public ResourceDigestManagerImpl(ResourceDigestGenerator digestGenerator, ResourceChangeTracker resourceChangeTracker) {
        this.digestGenerator = digestGenerator;
        this.resourceChangeTracker = resourceChangeTracker;
    }

    @PostInjection
    public void listenForInvalidations() {
        this.resourceChangeTracker.addInvalidationListener(this);
    }

    private Cached get(Resource resource) {
        Cached result = this.cache.get(resource);
        if (result == null) {
            result = new Cached(resource);
            this.cache.put(resource, result);
        }
        return result;
    }

    public String getDigest(Resource resource) {
        return this.get((Resource)resource).digest;
    }

    public long getTimeModified(Resource resource) {
        return this.get((Resource)resource).timeModified;
    }

    public boolean requiresDigest(Resource resource) {
        return this.get((Resource)resource).requiresDigest;
    }

    public void addInvalidationListener(InvalidationListener listener) {
        this.resourceChangeTracker.addInvalidationListener(listener);
    }

    public void objectWasInvalidated() {
        this.cache.clear();
    }

    private class Cached {
        final boolean requiresDigest;
        final String digest;
        final long timeModified;

        Cached(Resource resource) {
            this.requiresDigest = ResourceDigestManagerImpl.this.digestGenerator.requiresDigest(resource.getPath());
            URL url = resource.toURL();
            this.digest = this.requiresDigest && url != null ? ResourceDigestManagerImpl.this.digestGenerator.generateDigest(url) : null;
            this.timeModified = url != null ? ResourceDigestManagerImpl.this.resourceChangeTracker.trackResource(resource) : -1L;
        }
    }
}

