/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collection;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.PersistentFieldBundle;
import org.apache.tapestry5.services.PersistentFieldChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentFieldBundleImpl
implements PersistentFieldBundle {
    private final Map<String, Object> values = CollectionFactory.newMap();

    public PersistentFieldBundleImpl(Collection<PersistentFieldChange> changes) {
        for (PersistentFieldChange change : changes) {
            String key = this.buildKey(change.getComponentId(), change.getFieldName());
            this.values.put(key, change.getValue());
        }
    }

    private String buildKey(String componentId, String fieldName) {
        StringBuilder builder = new StringBuilder();
        if (componentId != null) {
            builder.append(componentId);
        }
        builder.append(':');
        builder.append(fieldName);
        return builder.toString();
    }

    @Override
    public boolean containsValue(String componentId, String fieldName) {
        String key = this.buildKey(componentId, fieldName);
        return this.values.containsKey(key);
    }

    @Override
    public Object getValue(String componentId, String fieldName) {
        String key = this.buildKey(componentId, fieldName);
        return this.values.get(key);
    }
}

