/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.internal.services.PageContentTypeAnalyzer;
import org.apache.tapestry5.internal.services.PageMarkupRenderer;
import org.apache.tapestry5.internal.services.PageResponseRenderer;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.services.MarkupWriterFactory;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.Response;
import org.slf4j.Logger;

public class PageResponseRendererImpl
implements PageResponseRenderer {
    private final RequestGlobals requestGlobals;
    private final PageMarkupRenderer markupRenderer;
    private final MarkupWriterFactory markupWriterFactory;
    private final PageContentTypeAnalyzer pageContentTypeAnalyzer;
    private final Response response;
    private final Logger logger;

    public PageResponseRendererImpl(RequestGlobals requestGlobals, MarkupWriterFactory markupWriterFactory, PageMarkupRenderer markupRenderer, PageContentTypeAnalyzer pageContentTypeAnalyzer, Response response, Logger logger) {
        this.requestGlobals = requestGlobals;
        this.markupWriterFactory = markupWriterFactory;
        this.markupRenderer = markupRenderer;
        this.pageContentTypeAnalyzer = pageContentTypeAnalyzer;
        this.response = response;
        this.logger = logger;
    }

    public void renderPageResponse(Page page) throws IOException {
        assert (page != null);
        this.requestGlobals.storeActivePageName(page.getName());
        ContentType contentType = this.pageContentTypeAnalyzer.findContentType(page);
        MarkupWriter writer = this.markupWriterFactory.newMarkupWriter(contentType);
        this.markupRenderer.renderPageMarkup(page, writer);
        PrintWriter pw = this.response.getPrintWriter(contentType.toString());
        long startNanos = System.nanoTime();
        writer.toMarkup(pw);
        long endNanos = System.nanoTime();
        if (this.logger.isDebugEnabled()) {
            long elapsedNanos = endNanos - startNanos;
            double elapsedSeconds = (float)elapsedNanos / 1.0E9f;
            this.logger.debug(String.format("Response DOM streamed to markup in %.3f seconds", elapsedSeconds));
        }
        pw.close();
    }
}

