/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.dom.DefaultMarkupModel;
import org.apache.tapestry5.dom.MarkupModel;
import org.apache.tapestry5.dom.XMLMarkupModel;
import org.apache.tapestry5.internal.services.MarkupWriterImpl;
import org.apache.tapestry5.internal.services.PageContentTypeAnalyzer;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.services.MarkupWriterFactory;

public class MarkupWriterFactoryImpl
implements MarkupWriterFactory {
    private final PageContentTypeAnalyzer analyzer;
    private final RequestPageCache cache;
    private final MarkupModel htmlModel = new DefaultMarkupModel();
    private final MarkupModel xmlModel = new XMLMarkupModel();
    private final MarkupModel htmlPartialModel = new DefaultMarkupModel(true);
    private final MarkupModel xmlPartialModel = new XMLMarkupModel(true);

    public MarkupWriterFactoryImpl(PageContentTypeAnalyzer analyzer, RequestPageCache cache) {
        this.analyzer = analyzer;
        this.cache = cache;
    }

    public MarkupWriter newMarkupWriter(ContentType contentType) {
        return this.newMarkupWriter(contentType, false);
    }

    public MarkupWriter newPartialMarkupWriter(ContentType contentType) {
        return this.newMarkupWriter(contentType, true);
    }

    private MarkupWriter newMarkupWriter(ContentType contentType, boolean partial) {
        boolean isHTML = contentType.getMimeType().equalsIgnoreCase("text/html");
        MarkupModel model = partial ? (isHTML ? this.htmlPartialModel : this.xmlPartialModel) : (isHTML ? this.htmlModel : this.xmlModel);
        return new MarkupWriterImpl(model, contentType.getCharset());
    }

    public MarkupWriter newMarkupWriter(String pageName) {
        Page page = this.cache.get(pageName);
        ContentType contentType = this.analyzer.findContentType(page);
        return this.newMarkupWriter(contentType);
    }
}

