/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.internal.services.PageResponseRenderer;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.services.ComponentEventRequestFilter;
import org.apache.tapestry5.services.ComponentEventRequestHandler;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;

public class ImmediateActionRenderResponseFilter
implements ComponentEventRequestFilter {
    private final Request request;
    private final Response response;
    private final PageResponseRenderer renderer;

    public ImmediateActionRenderResponseFilter(Request request, PageResponseRenderer renderer, Response response) {
        this.request = request;
        this.renderer = renderer;
        this.response = response;
    }

    public void handle(ComponentEventRequestParameters parameters, ComponentEventRequestHandler handler) throws IOException {
        handler.handle(parameters);
        if (this.response.isCommitted()) {
            return;
        }
        Page page = (Page)this.request.getAttribute("tapestry.immediate-response-page");
        if (page != null) {
            page.getRootElement().triggerEvent("activate", new Object[0], null);
            this.renderer.renderPageResponse(page);
            return;
        }
        throw new IllegalStateException("Sanity check - neither a stream response nor a redirect response was generated for this action request.");
    }
}

