/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.HttpServletRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoredPathsFilter
implements HttpServletRequestFilter {
    private final Pattern[] ignoredPatterns;

    public IgnoredPathsFilter(Collection<String> configuration) {
        this.ignoredPatterns = new Pattern[configuration.size()];
        int i = 0;
        for (String regexp : configuration) {
            Pattern p = Pattern.compile(regexp, 2);
            this.ignoredPatterns[i++] = p;
        }
    }

    @Override
    public boolean service(HttpServletRequest request, HttpServletResponse response, HttpServletRequestHandler handler) throws IOException {
        String path = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            path = path + pathInfo;
        }
        for (Pattern p : this.ignoredPatterns) {
            if (!p.matcher(path).matches()) continue;
            return false;
        }
        return handler.service(request, response);
    }
}

