/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import javax.servlet.http.Cookie;
import org.apache.tapestry5.internal.services.CookieSink;
import org.apache.tapestry5.internal.services.CookieSource;
import org.apache.tapestry5.ioc.annotations.IntermediateType;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.util.TimeInterval;
import org.apache.tapestry5.services.Cookies;
import org.apache.tapestry5.services.Request;

public class CookiesImpl
implements Cookies {
    private final Request request;
    private final CookieSource cookieSource;
    private final CookieSink cookieSink;
    private final int defaultMaxAge;

    public CookiesImpl(Request request, CookieSource cookieSource, CookieSink cookieSink, @Symbol(value="tapestry.default-cookie-max-age") @IntermediateType(value=TimeInterval.class) long defaultMaxAge) {
        this.request = request;
        this.cookieSource = cookieSource;
        this.cookieSink = cookieSink;
        this.defaultMaxAge = (int)(defaultMaxAge / 1000L);
    }

    public String readCookieValue(String name) {
        Cookie[] cookies = this.cookieSource.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cooky : cookies) {
            if (!cooky.getName().equals(name)) continue;
            return cooky.getValue();
        }
        return null;
    }

    public void writeCookieValue(String name, String value) {
        this.writeCookieValue(name, value, this.defaultMaxAge);
    }

    public void writeCookieValue(String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(this.request.getContextPath() + "/");
        cookie.setMaxAge(maxAge);
        cookie.setSecure(this.request.isSecure());
        this.cookieSink.addCookie(cookie);
    }

    public void writeCookieValue(String name, String value, String path) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        cookie.setMaxAge(this.defaultMaxAge);
        cookie.setSecure(this.request.isSecure());
        this.cookieSink.addCookie(cookie);
    }

    public void writeDomainCookieValue(String name, String value, String domain) {
        this.writeDomainCookieValue(name, value, domain, this.defaultMaxAge);
    }

    public void writeDomainCookieValue(String name, String value, String domain, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(this.request.getContextPath() + "/");
        cookie.setDomain(domain);
        cookie.setMaxAge(maxAge);
        cookie.setSecure(this.request.isSecure());
        this.cookieSink.addCookie(cookie);
    }

    public void writeCookieValue(String name, String value, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        cookie.setDomain(domain);
        cookie.setMaxAge(this.defaultMaxAge);
        cookie.setSecure(this.request.isSecure());
        this.cookieSink.addCookie(cookie);
    }

    public void removeCookieValue(String name) {
        Cookie cookie = new Cookie(name, null);
        cookie.setPath(this.request.getContextPath() + "/");
        cookie.setMaxAge(0);
        cookie.setSecure(this.request.isSecure());
        this.cookieSink.addCookie(cookie);
    }
}

