/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.internal.services.AbstractAsset;
import org.apache.tapestry5.internal.services.ContextResource;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.AssetFactory;
import org.apache.tapestry5.services.AssetPathConverter;
import org.apache.tapestry5.services.Context;
import org.apache.tapestry5.services.assets.AssetPathConstructor;

public class ContextAssetFactory
implements AssetFactory {
    private final AssetPathConstructor assetPathConstructor;
    private final Resource rootResource;
    private final AssetPathConverter converter;
    private final boolean invariant;

    public ContextAssetFactory(AssetPathConstructor assetPathConstructor, Context context, AssetPathConverter converter) {
        this.assetPathConstructor = assetPathConstructor;
        this.converter = converter;
        this.rootResource = new ContextResource(context, "/");
        this.invariant = this.converter.isInvariant();
    }

    public Asset createAsset(Resource resource) {
        String defaultPath = this.assetPathConstructor.constructAssetPath("ctx", resource.getPath());
        if (this.invariant) {
            return this.createInvariantAsset(resource, defaultPath);
        }
        return this.createVariantAsset(resource, defaultPath);
    }

    private Asset createInvariantAsset(final Resource resource, final String defaultPath) {
        return new AbstractAsset(true){
            private String clientURL;

            public Resource getResource() {
                return resource;
            }

            public String toClientURL() {
                if (this.clientURL == null) {
                    this.clientURL = ContextAssetFactory.this.converter.convertAssetPath(defaultPath);
                }
                return this.clientURL;
            }
        };
    }

    private Asset createVariantAsset(final Resource resource, final String defaultPath) {
        return new AbstractAsset(false){

            public Resource getResource() {
                return resource;
            }

            public String toClientURL() {
                return ContextAssetFactory.this.converter.convertAssetPath(defaultPath);
            }
        };
    }

    public Resource getRootResource() {
        return this.rootResource;
    }
}

