/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.internal.services.ActionRenderResponseGenerator;
import org.apache.tapestry5.internal.services.ComponentInstanceProcessor;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.Traditional;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Marker(value={Traditional.class, ComponentInstanceProcessor.class})
public class ComponentInstanceResultProcessor
implements ComponentEventResultProcessor<Component> {
    private final RequestPageCache requestPageCache;
    private final Logger logger;
    private final ActionRenderResponseGenerator generator;

    public ComponentInstanceResultProcessor(Logger logger, RequestPageCache requestPageCache, ActionRenderResponseGenerator generator) {
        this.requestPageCache = requestPageCache;
        this.logger = logger;
        this.generator = generator;
    }

    @Override
    public void processResultValue(Component value) throws IOException {
        ComponentResources resources = value.getComponentResources();
        if (resources.getContainer() != null) {
            this.logger.warn(ServicesMessages.componentInstanceIsNotAPage(value));
        }
        Page page = this.requestPageCache.get(resources.getPageName());
        this.generator.generateResponse(page);
    }
}

