/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.internal.services.EventImpl;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.internal.structure.ComponentPageElementResources;
import org.apache.tapestry5.runtime.ComponentEvent;
import org.slf4j.Logger;

public class ComponentEventImpl
extends EventImpl
implements ComponentEvent {
    private final String eventType;
    private final String originatingComponentId;
    private final EventContext context;
    private final ComponentPageElementResources elementResources;

    public ComponentEventImpl(String eventType, String originatingComponentId, EventContext context, ComponentEventCallback handler, ComponentPageElementResources elementResources, Logger logger) {
        super(handler, logger, elementResources);
        this.eventType = eventType;
        this.originatingComponentId = originatingComponentId;
        this.elementResources = elementResources;
        this.context = context;
    }

    public String toString() {
        return String.format("ComponentEvent[%s from %s]", this.eventType, this.originatingComponentId.length() == 0 ? "(self)" : this.originatingComponentId);
    }

    public boolean matches(String eventType, String componentId, int parameterCount) {
        if (this.isAborted()) {
            return false;
        }
        return this.eventType.equalsIgnoreCase(eventType) && this.context.getCount() >= parameterCount && (this.originatingComponentId.equalsIgnoreCase(componentId) || componentId.equals(""));
    }

    public Object coerceContext(int index, String desiredTypeName) {
        if (index >= this.context.getCount()) {
            throw new IllegalArgumentException(ServicesMessages.contextIndexOutOfRange(this.getMethodDescription()));
        }
        try {
            Class desiredType = this.elementResources.toClass(desiredTypeName);
            return this.context.get(desiredType, index);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ServicesMessages.exceptionInMethodParameter(this.getMethodDescription(), index, ex), ex);
        }
    }

    public Object[] getContext() {
        int count = this.context.getCount();
        Object[] result = new Object[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.context.get(Object.class, i);
        }
        return result;
    }

    public EventContext getEventContext() {
        return this.context;
    }
}

