/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassNameLocator;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.InvalidationListener;
import org.apache.tapestry5.services.LibraryMapping;
import org.apache.tapestry5.services.transform.ControlledPackageType;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentClassResolverImpl
implements ComponentClassResolver,
InvalidationListener {
    private static final String CORE_LIBRARY_PREFIX = "core/";
    private static final Pattern SPLIT_PACKAGE_PATTERN = Pattern.compile("\\.");
    private static final Pattern SPLIT_FOLDER_PATTERN = Pattern.compile("/");
    private static final int LOGICAL_NAME_BUFFER_SIZE = 40;
    private final Logger logger;
    private final ClassNameLocator classNameLocator;
    private final String startPageName;
    private final Map<String, List<String>> mappings = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, ControlledPackageType> packageMappings = CollectionFactory.newMap();
    private volatile boolean needsRebuild = true;
    private volatile Data data = new Data();
    private static final Pattern DOT = Pattern.compile("\\.");

    public ComponentClassResolverImpl(Logger logger, ClassNameLocator classNameLocator, @Symbol(value="tapestry.start-page-name") String startPageName, Collection<LibraryMapping> mappings) {
        this.logger = logger;
        this.classNameLocator = classNameLocator;
        this.startPageName = startPageName;
        for (LibraryMapping mapping : mappings) {
            String prefix = mapping.getPathPrefix();
            while (prefix.startsWith("/")) {
                prefix = prefix.substring(1);
            }
            while (prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            String rootPackage = mapping.getRootPackage();
            List packages = this.mappings.get(prefix);
            if (packages == null) {
                packages = CollectionFactory.newList();
                this.mappings.put(prefix, packages);
            }
            packages.add(rootPackage);
            this.addSubpackagesToPackageMapping(rootPackage);
        }
    }

    private void addSubpackagesToPackageMapping(String rootPackage) {
        for (String subpackage : InternalConstants.SUBPACKAGES) {
            this.packageMappings.put(rootPackage + "." + subpackage, ControlledPackageType.COMPONENT);
        }
    }

    @Override
    public Map<String, ControlledPackageType> getControlledPackageMapping() {
        return Collections.unmodifiableMap(this.packageMappings);
    }

    @Override
    public synchronized void objectWasInvalidated() {
        this.needsRebuild = true;
    }

    private Data getData() {
        if (!this.needsRebuild) {
            return this.data;
        }
        Data newData = new Data();
        for (String prefix : this.mappings.keySet()) {
            List<String> packages = this.mappings.get(prefix);
            String folder = prefix + "/";
            for (String packageName : packages) {
                newData.rebuild(folder, packageName);
            }
        }
        this.showChanges("pages", this.data.pageToClassName, newData.pageToClassName);
        this.showChanges("components", this.data.componentToClassName, newData.componentToClassName);
        this.showChanges("mixins", this.data.mixinToClassName, newData.mixinToClassName);
        this.needsRebuild = false;
        this.data = newData;
        return this.data;
    }

    private static int countUnique(Map<String, String> map) {
        return CollectionFactory.newSet(map.values()).size();
    }

    private void showChanges(String title, Map<String, String> savedMap, Map<String, String> newMap) {
        if (((Object)savedMap).equals(newMap)) {
            return;
        }
        Map core = CollectionFactory.newMap();
        Map nonCore = CollectionFactory.newMap();
        int maxLength = 0;
        for (String name : newMap.keySet()) {
            if (name.startsWith(CORE_LIBRARY_PREFIX)) {
                String key = name.substring(CORE_LIBRARY_PREFIX.length());
                maxLength = Math.max(maxLength, key.length());
                core.put(key, newMap.get(name));
                continue;
            }
            maxLength = Math.max(maxLength, name.length());
            nonCore.put(name, newMap.get(name));
        }
        core.putAll(nonCore);
        StringBuilder builder = new StringBuilder(2000);
        Formatter f = new Formatter(builder);
        int oldCount = ComponentClassResolverImpl.countUnique(savedMap);
        int newCount = ComponentClassResolverImpl.countUnique(newMap);
        f.format("Available %s (%d", title, newCount);
        if (oldCount > 0 && oldCount != newCount) {
            f.format(", +%d", newCount - oldCount);
        }
        builder.append("):\n");
        String formatString = "%" + maxLength + "s: %s\n";
        List sorted = InternalUtils.sortedKeys((Map)core);
        for (String name : sorted) {
            String className = (String)core.get(name);
            if (name.equals("")) {
                name = "(blank)";
            }
            f.format(formatString, name, className);
        }
        this.logger.info(builder.toString());
    }

    @Override
    public String resolvePageNameToClassName(String pageName) {
        Data data = this.getData();
        String result = this.locate(pageName, data.pageToClassName);
        if (result == null) {
            throw new UnknownValueException(String.format("Unable to resolve '%s' to a page class name.", pageName), new AvailableValues("Page names", this.presentableNames(data.pageToClassName)));
        }
        return result;
    }

    @Override
    public boolean isPageName(String pageName) {
        return this.locate(pageName, this.getData().pageToClassName) != null;
    }

    @Override
    public boolean isPage(String pageClassName) {
        return this.locate(pageClassName, this.getData().pageClassNameToLogicalName) != null;
    }

    @Override
    public List<String> getPageNames() {
        Data data = this.getData();
        List result = CollectionFactory.newList(data.pageClassNameToLogicalName.values());
        Collections.sort(result);
        return result;
    }

    @Override
    public String resolveComponentTypeToClassName(String componentType) {
        Data data = this.getData();
        String result = this.locate(componentType, data.componentToClassName);
        if (result == null) {
            throw new UnknownValueException(String.format("Unable to resolve '%s' to a component class name.", componentType), new AvailableValues("Component types", this.presentableNames(data.componentToClassName)));
        }
        return result;
    }

    Collection<String> presentableNames(Map<String, ?> map) {
        Set result = CollectionFactory.newSet();
        for (String name : map.keySet()) {
            if (name.startsWith(CORE_LIBRARY_PREFIX)) {
                result.add(name.substring(CORE_LIBRARY_PREFIX.length()));
                continue;
            }
            result.add(name);
        }
        return result;
    }

    @Override
    public String resolveMixinTypeToClassName(String mixinType) {
        Data data = this.getData();
        String result = this.locate(mixinType, data.mixinToClassName);
        if (result == null) {
            throw new UnknownValueException(String.format("Unable to resolve '%s' to a mixin class name.", mixinType), new AvailableValues("Mixin types", this.presentableNames(data.mixinToClassName)));
        }
        return result;
    }

    private String locate(String logicalName, Map<String, String> logicalNameToClassName) {
        String result = logicalNameToClassName.get(logicalName);
        if (result != null) {
            return result;
        }
        return logicalNameToClassName.get(CORE_LIBRARY_PREFIX + logicalName);
    }

    @Override
    public String resolvePageClassNameToPageName(String pageClassName) {
        String result = (String)this.getData().pageClassNameToLogicalName.get(pageClassName);
        if (result == null) {
            throw new IllegalArgumentException(ServicesMessages.pageNameUnresolved(pageClassName));
        }
        return result;
    }

    @Override
    public String canonicalizePageName(String pageName) {
        Data data = this.getData();
        String result = this.locate(pageName, data.pageNameToCanonicalPageName);
        if (result == null) {
            throw new UnknownValueException(String.format("Unable to resolve '%s' to a known page name.", pageName), new AvailableValues("Page names", this.presentableNames(data.pageNameToCanonicalPageName)));
        }
        return result;
    }

    @Override
    public Map<String, String> getFolderToPackageMapping() {
        Map result = CollectionFactory.newCaseInsensitiveMap();
        for (String folder : this.mappings.keySet()) {
            List<String> packageNames = this.mappings.get(folder);
            String packageName = ComponentClassResolverImpl.findCommonPackageNameForFolder(folder, packageNames);
            result.put(folder, packageName);
        }
        return result;
    }

    static String findCommonPackageNameForFolder(String folder, List<String> packageNames) {
        String packageName = ComponentClassResolverImpl.findCommonPackageName(packageNames);
        if (packageName == null) {
            throw new RuntimeException(String.format("Package names for library folder '%s' (%s) can not be reduced to a common base package (of at least one term).", folder, InternalUtils.joinSorted(packageNames)));
        }
        return packageName;
    }

    static String findCommonPackageName(List<String> packageNames) {
        String commonPackageName = packageNames.get(0);
        for (int i = 1; i < packageNames.size() && (commonPackageName = ComponentClassResolverImpl.findCommonPackageName(commonPackageName, packageNames.get(i))) != null; ++i) {
        }
        return commonPackageName;
    }

    static String findCommonPackageName(String commonPackageName, String packageName) {
        String[] commonExploded = ComponentClassResolverImpl.explode(commonPackageName);
        String[] exploded = ComponentClassResolverImpl.explode(packageName);
        int count = Math.min(commonExploded.length, exploded.length);
        int commonLength = 0;
        int commonTerms = 0;
        for (int i = 0; i < count && exploded[i].equals(commonExploded[i]); ++i) {
            commonLength += exploded[i].length() + (i == 0 ? 0 : 1);
            ++commonTerms;
        }
        if (commonTerms < 1) {
            return null;
        }
        return commonPackageName.substring(0, commonLength);
    }

    private static String[] explode(String packageName) {
        return DOT.split(packageName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Data {
        private final Map<String, String> pageToClassName = CollectionFactory.newCaseInsensitiveMap();
        private final Map<String, String> componentToClassName = CollectionFactory.newCaseInsensitiveMap();
        private final Map<String, String> mixinToClassName = CollectionFactory.newCaseInsensitiveMap();
        private final Map<String, String> pageClassNameToLogicalName = CollectionFactory.newMap();
        private final Map<String, String> pageNameToCanonicalPageName = CollectionFactory.newCaseInsensitiveMap();

        private Data() {
        }

        private void rebuild(String pathPrefix, String rootPackage) {
            this.fillNameToClassNameMap(pathPrefix, rootPackage, "pages", this.pageToClassName);
            this.fillNameToClassNameMap(pathPrefix, rootPackage, "components", this.componentToClassName);
            this.fillNameToClassNameMap(pathPrefix, rootPackage, "mixins", this.mixinToClassName);
        }

        private void fillNameToClassNameMap(String pathPrefix, String rootPackage, String subPackage, Map<String, String> logicalNameToClassName) {
            String searchPackage = rootPackage + "." + subPackage;
            boolean isPage = subPackage.equals("pages");
            Collection classNames = ComponentClassResolverImpl.this.classNameLocator.locateClassNames(searchPackage);
            int startPos = searchPackage.length() + 1;
            for (String name : classNames) {
                String logicalName = this.toLogicalName(name, pathPrefix, startPos, true);
                String unstrippedName = this.toLogicalName(name, pathPrefix, startPos, false);
                if (isPage) {
                    String lastTerm;
                    int lastSlashx = logicalName.lastIndexOf("/");
                    String string = lastTerm = lastSlashx < 0 ? logicalName : logicalName.substring(lastSlashx + 1);
                    if (lastTerm.equalsIgnoreCase("index") || lastTerm.equalsIgnoreCase(ComponentClassResolverImpl.this.startPageName)) {
                        String reducedName;
                        String string2 = reducedName = lastSlashx < 0 ? "" : logicalName.substring(0, lastSlashx);
                        if (!lastTerm.equalsIgnoreCase(ComponentClassResolverImpl.this.startPageName) || !logicalNameToClassName.containsKey(reducedName)) {
                            logicalNameToClassName.put(reducedName, name);
                            this.pageNameToCanonicalPageName.put(reducedName, logicalName);
                        }
                    }
                    this.pageClassNameToLogicalName.put(name, logicalName);
                    this.pageNameToCanonicalPageName.put(logicalName, logicalName);
                    this.pageNameToCanonicalPageName.put(unstrippedName, logicalName);
                }
                logicalNameToClassName.put(logicalName, name);
                logicalNameToClassName.put(unstrippedName, name);
            }
        }

        private String toLogicalName(String className, String pathPrefix, int startPos, boolean stripTerms) {
            String logicalName;
            List terms = CollectionFactory.newList();
            this.addAll(terms, SPLIT_FOLDER_PATTERN, pathPrefix);
            this.addAll(terms, SPLIT_PACKAGE_PATTERN, className.substring(startPos));
            StringBuilder builder = new StringBuilder(40);
            String sep = "";
            String unstripped = logicalName = (String)terms.remove(terms.size() - 1);
            for (String term : terms) {
                builder.append(sep);
                builder.append(term);
                sep = "/";
                if (!stripTerms) continue;
                logicalName = this.stripTerm(term, logicalName);
            }
            if (logicalName.equals("")) {
                logicalName = unstripped;
            }
            builder.append(sep);
            builder.append(logicalName);
            return builder.toString();
        }

        private void addAll(List<String> terms, Pattern splitter, String input) {
            for (String term : splitter.split(input)) {
                if (term.equals("")) continue;
                terms.add(term);
            }
        }

        private String stripTerm(String term, String logicalName) {
            if (this.isCaselessPrefix(term, logicalName)) {
                logicalName = logicalName.substring(term.length());
            }
            if (this.isCaselessSuffix(term, logicalName)) {
                logicalName = logicalName.substring(0, logicalName.length() - term.length());
            }
            return logicalName;
        }

        private boolean isCaselessPrefix(String prefix, String string) {
            return string.regionMatches(true, 0, prefix, 0, prefix.length());
        }

        private boolean isCaselessSuffix(String suffix, String string) {
            return string.regionMatches(true, string.length() - suffix.length(), suffix, 0, suffix.length());
        }
    }
}

