/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.corelib.data.InsertPosition;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONLiteral;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ClientBehaviorSupport;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class ClientBehaviorSupportImpl
implements ClientBehaviorSupport {
    private final JavaScriptSupport javascriptSupport;
    private final Environment environment;
    private final JSONObject validations = new JSONObject();

    public ClientBehaviorSupportImpl(JavaScriptSupport javascriptSupport, Environment environment) {
        this.javascriptSupport = javascriptSupport;
        this.environment = environment;
    }

    public void addZone(String clientId, String showFunctionName, String updateFunctionName) {
        JSONObject spec = new JSONObject(new String[]{"element", clientId});
        this.addFunction(spec, "show", showFunctionName);
        this.addFunction(spec, "update", updateFunctionName);
        FormSupport formSupport = this.environment.peek(FormSupport.class);
        if (formSupport != null) {
            JSONObject parameters = new JSONObject(new String[]{"t:formid", formSupport.getClientId(), "t:formcomponentid", formSupport.getFormComponentId()});
            spec.put("parameters", (Object)parameters);
        }
        this.javascriptSupport.addInitializerCall("zone", spec);
    }

    private void addFunction(JSONObject spec, String key, String functionName) {
        if (functionName != null) {
            spec.put(key, (Object)functionName.toLowerCase());
        }
    }

    public void linkZone(String linkId, String elementId, Link eventLink) {
        JSONObject spec = new JSONObject(new String[]{"linkId", linkId, "zoneId", elementId, "url", eventLink.toURI()});
        this.javascriptSupport.addInitializerCall("linkZone", spec);
    }

    public void addFormFragment(String clientId, String showFunctionName, String hideFunctionName) {
        this.addFormFragment(clientId, false, showFunctionName, hideFunctionName, null);
    }

    public void addFormFragment(String clientId, boolean alwaysSubmit, String showFunctionName, String hideFunctionName) {
        this.addFormFragment(clientId, false, showFunctionName, hideFunctionName, null);
    }

    public void addFormFragment(String clientId, boolean alwaysSubmit, String showFunctionName, String hideFunctionName, String visibilityBoundFunctionName) {
        JSONObject spec = new JSONObject(new String[]{"element", clientId});
        this.addFunction(spec, "show", showFunctionName);
        this.addFunction(spec, "hide", hideFunctionName);
        if (visibilityBoundFunctionName != null) {
            spec.put("bound", (Object)new JSONLiteral(visibilityBoundFunctionName));
        }
        if (alwaysSubmit) {
            spec.put("alwaysSubmit", (Object)true);
        }
        this.javascriptSupport.addInitializerCall("formFragment", spec);
    }

    public void addFormInjector(String clientId, Link link, InsertPosition insertPosition, String showFunctionName) {
        JSONObject spec = new JSONObject(new String[]{"element", clientId, "url", link.toURI()});
        if (insertPosition == InsertPosition.BELOW) {
            spec.put("below", (Object)true);
        }
        this.addFunction(spec, "show", showFunctionName);
        this.javascriptSupport.addInitializerCall("formInjector", spec);
    }

    public void addValidation(Field field, String validationName, String message, Object constraint) {
        JSONArray specs;
        String fieldId = field.getClientId();
        if (this.validations.has(fieldId)) {
            specs = this.validations.getJSONArray(fieldId);
        } else {
            specs = new JSONArray();
            this.validations.put(fieldId, (Object)specs);
        }
        JSONArray thisSpec = new JSONArray();
        thisSpec.put((Object)validationName);
        thisSpec.put((Object)message);
        if (constraint != null) {
            thisSpec.put(constraint);
        }
        specs.put((Object)thisSpec);
    }

    public void commit() {
        if (this.validations.length() != 0) {
            this.javascriptSupport.addInitializerCall("validate", this.validations);
        }
    }
}

