/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Locale;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.transform.InjectionProvider2;

public class AssetInjectionProvider
implements InjectionProvider2 {
    private final SymbolSource symbolSource;
    private final AssetSource assetSource;

    public AssetInjectionProvider(SymbolSource symbolSource, AssetSource assetSource) {
        this.symbolSource = symbolSource;
        this.assetSource = assetSource;
    }

    public boolean provideInjection(PlasticField field, ObjectLocator locator, MutableComponentModel componentModel) {
        Path path = (Path)field.getAnnotation(Path.class);
        if (path == null) {
            return false;
        }
        final String expanded = this.symbolSource.expandSymbols(path.value());
        final Resource baseResource = componentModel.getBaseResource();
        ComputedValue<Asset> computedAsset = new ComputedValue<Asset>(){

            public Asset get(InstanceContext context) {
                ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                Locale locale = resources.getLocale();
                return AssetInjectionProvider.this.assetSource.getAsset(baseResource, expanded, locale);
            }
        };
        field.injectComputed((ComputedValue)computedAsset);
        return true;
    }
}

