/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.ObjectProvider;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.LockSupport;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.services.InvalidationListener;
import org.apache.tapestry5.services.messages.ComponentMessagesSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationMessageCatalogObjectProvider
extends LockSupport
implements ObjectProvider,
InvalidationListener {
    private final ObjectLocator objectLocator;
    private ComponentMessagesSource messagesSource;
    private ThreadLocale threadLocale;
    private final Map<Locale, Messages> localeToMessages = CollectionFactory.newMap();
    private Messages proxy;

    public ApplicationMessageCatalogObjectProvider(ObjectLocator locator) {
        this.objectLocator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Messages getProxy() {
        try {
            this.acquireReadLock();
            if (this.proxy == null) {
                this.createProxy();
            }
            Messages messages = this.proxy;
            return messages;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProxy() {
        try {
            this.upgradeReadLockToWriteLock();
            this.messagesSource = (ComponentMessagesSource)this.objectLocator.getService(ComponentMessagesSource.class);
            this.threadLocale = (ThreadLocale)this.objectLocator.getService(ThreadLocale.class);
            PlasticProxyFactory proxyFactory = (PlasticProxyFactory)this.objectLocator.getService("PlasticProxyFactory", PlasticProxyFactory.class);
            this.proxy = (Messages)proxyFactory.createProxy(Messages.class, (ObjectCreator)new ApplicationMessagesObjectCreator(), "<ApplicationMessagesProxy>");
            this.messagesSource.getInvalidationEventHub().addInvalidationListener(this);
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }

    public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
        if (objectType.equals(Messages.class)) {
            return objectType.cast(this.getProxy());
        }
        return null;
    }

    @Override
    public void objectWasInvalidated() {
        this.localeToMessages.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplicationMessagesObjectCreator
    implements ObjectCreator<Messages> {
        private ApplicationMessagesObjectCreator() {
        }

        public Messages createObject() {
            Locale locale = ApplicationMessageCatalogObjectProvider.this.threadLocale.getLocale();
            Messages messages = (Messages)ApplicationMessageCatalogObjectProvider.this.localeToMessages.get(locale);
            if (messages == null) {
                messages = ApplicationMessageCatalogObjectProvider.this.messagesSource.getApplicationCatalog(locale);
                ApplicationMessageCatalogObjectProvider.this.localeToMessages.put(locale, messages);
            }
            return messages;
        }
    }
}

