/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.internal.services.AjaxPartialResponseRenderer;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.MarkupWriterFactory;
import org.apache.tapestry5.services.PartialMarkupRenderer;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;

public class AjaxPartialResponseRendererImpl
implements AjaxPartialResponseRenderer {
    private final MarkupWriterFactory factory;
    private final Request request;
    private final Response response;
    private final PartialMarkupRenderer partialMarkupRenderer;
    private final String outputEncoding;
    private final boolean compactJSON;
    private final Environment environment;

    public AjaxPartialResponseRendererImpl(MarkupWriterFactory factory, Request request, Response response, PartialMarkupRenderer partialMarkupRenderer, @Inject @Symbol(value="tapestry.charset") String outputEncoding, @Symbol(value="tapestry.compact-json") boolean compactJSON, Environment environment) {
        this.factory = factory;
        this.request = request;
        this.response = response;
        this.partialMarkupRenderer = partialMarkupRenderer;
        this.outputEncoding = outputEncoding;
        this.compactJSON = compactJSON;
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPartialPageMarkup() throws IOException {
        this.environment.cloak();
        try {
            ContentType pageContentType = (ContentType)this.request.getAttribute("content-type");
            ContentType contentType = new ContentType("application/json", this.outputEncoding);
            MarkupWriter writer = this.factory.newPartialMarkupWriter(pageContentType);
            JSONObject reply = new JSONObject();
            this.partialMarkupRenderer.renderMarkup(writer, reply);
            PrintWriter pw = this.response.getPrintWriter(contentType.toString());
            reply.print(pw, this.compactJSON);
            pw.close();
        }
        finally {
            this.environment.decloak();
        }
    }
}

