/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.pageload;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.pageload.ComponentAssembler;
import org.apache.tapestry5.internal.pageload.ComponentAssemblerSource;
import org.apache.tapestry5.internal.pageload.EmbeddedComponentAssembler;
import org.apache.tapestry5.internal.pageload.PageloadMessages;
import org.apache.tapestry5.internal.pageload.ParameterBinder;
import org.apache.tapestry5.internal.pageload.ParameterBinderImpl;
import org.apache.tapestry5.internal.services.ComponentInstantiatorSource;
import org.apache.tapestry5.internal.services.Instantiator;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.Orderable;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.model.EmbeddedComponentModel;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedComponentAssemblerImpl
implements EmbeddedComponentAssembler {
    private final ComponentInstantiatorSource instantiatorSource;
    private final ComponentAssemblerSource assemblerSource;
    private final ComponentResourceSelector selector;
    private final ComponentModel componentModel;
    private final Location location;
    private final Map<String, Instantiator> mixinIdToInstantiator = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, String[]> mixinsIdToOrderConstraints = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, ParameterBinder> parameterNameToBinder = CollectionFactory.newCaseInsensitiveMap();
    private final String informalParametersMixinId;
    private final String componentPsuedoMixinId;
    private Map<String, Boolean> bound;

    public EmbeddedComponentAssemblerImpl(ComponentAssemblerSource assemblerSource, ComponentInstantiatorSource instantiatorSource, ComponentClassResolver componentClassResolver, String componentClassName, ComponentResourceSelector selector, EmbeddedComponentModel embeddedModel, String templateMixins, Location location) {
        this.assemblerSource = assemblerSource;
        this.instantiatorSource = instantiatorSource;
        this.selector = selector;
        this.location = location;
        this.componentModel = this.getModel(componentClassName);
        for (String className : this.componentModel.getMixinClassNames()) {
            this.addMixin(className, this.componentModel.getOrderForMixin(className));
        }
        if (embeddedModel != null) {
            for (String className : embeddedModel.getMixinClassNames()) {
                this.addMixin(className, embeddedModel.getConstraintsForMixin(className));
            }
        }
        for (String mixinDef : TapestryInternalUtils.splitAtCommas(templateMixins)) {
            Orderable<String> order = TapestryInternalUtils.mixinTypeAndOrder(mixinDef);
            String className = componentClassResolver.resolveMixinTypeToClassName(order.getId());
            this.addMixin(className, order.getConstraints());
        }
        this.componentPsuedoMixinId = InternalUtils.lastTerm((String)componentClassName);
        this.informalParametersMixinId = this.prescanMixins();
    }

    private String prescanMixins() {
        String supportsInformals = null;
        for (Map.Entry<String, Instantiator> entry : this.mixinIdToInstantiator.entrySet()) {
            String mixinId = entry.getKey();
            ComponentModel mixinModel = entry.getValue().getModel();
            this.updateParameterNameToQualified(mixinId, mixinModel);
            if (supportsInformals != null || !mixinModel.getSupportsInformalParameters()) continue;
            supportsInformals = mixinId;
        }
        this.updateParameterNameToQualified(null, this.componentModel);
        return supportsInformals;
    }

    private void updateParameterNameToQualified(String mixinId, ComponentModel model) {
        for (String parameterName : model.getParameterNames()) {
            String defaultBindingPrefix = model.getParameterModel(parameterName).getDefaultBindingPrefix();
            ParameterBinderImpl binder = new ParameterBinderImpl(mixinId, parameterName, defaultBindingPrefix);
            this.parameterNameToBinder.put(parameterName, binder);
            if (mixinId == null) continue;
            this.parameterNameToBinder.put(mixinId + "." + parameterName, binder);
        }
    }

    private void addMixin(String className, String ... order) {
        Instantiator mixinInstantiator = this.instantiatorSource.getInstantiator(className);
        String mixinId = InternalUtils.lastTerm((String)className);
        if (this.mixinIdToInstantiator.containsKey(mixinId)) {
            throw new TapestryException(PageloadMessages.uniqueMixinRequired(mixinId), this.location, null);
        }
        this.mixinIdToInstantiator.put(mixinId, mixinInstantiator);
        this.mixinsIdToOrderConstraints.put(mixinId, order);
    }

    private ComponentModel getModel(String className) {
        return this.instantiatorSource.getInstantiator(className).getModel();
    }

    @Override
    public ComponentAssembler getComponentAssembler() {
        return this.assemblerSource.getAssembler(this.componentModel.getComponentClassName(), this.selector);
    }

    @Override
    public ParameterBinder createParameterBinder(String qualifiedParameterName) {
        int dotx = qualifiedParameterName.indexOf(46);
        if (dotx < 0) {
            return this.createParameterBinderFromSimpleParameterName(qualifiedParameterName);
        }
        return this.createParameterBinderFromQualifiedParameterName(qualifiedParameterName, qualifiedParameterName.substring(0, dotx), qualifiedParameterName.substring(dotx + 1));
    }

    private ParameterBinder createParameterBinderFromSimpleParameterName(String parameterName) {
        ParameterBinder binder = this.getComponentAssembler().getBinder(parameterName);
        if (binder != null) {
            return binder;
        }
        binder = this.parameterNameToBinder.get(parameterName);
        if (binder != null) {
            return binder;
        }
        if (this.informalParametersMixinId != null) {
            return new ParameterBinderImpl(this.informalParametersMixinId, parameterName, null);
        }
        if (this.componentModel.getSupportsInformalParameters()) {
            return new ParameterBinderImpl(null, parameterName, null);
        }
        return null;
    }

    private ParameterBinder createParameterBinderFromQualifiedParameterName(String qualifiedParameterName, String mixinId, String parameterName) {
        if (mixinId.equalsIgnoreCase(this.componentPsuedoMixinId)) {
            return this.createParameterBinderForComponent(qualifiedParameterName, parameterName);
        }
        if (!this.mixinIdToInstantiator.containsKey(mixinId)) {
            throw new TapestryException(String.format("Mixin id for parameter '%s' not found. Attached mixins: %s.", qualifiedParameterName, InternalUtils.joinSorted(this.mixinIdToInstantiator.keySet())), this.location, null);
        }
        ParameterBinder binder = this.parameterNameToBinder.get(qualifiedParameterName);
        if (binder != null) {
            return binder;
        }
        Instantiator instantiator = this.mixinIdToInstantiator.get(mixinId);
        assert (instantiator != null);
        return this.bindInformalParameter(qualifiedParameterName, mixinId, parameterName, instantiator.getModel());
    }

    private ParameterBinder bindInformalParameter(String qualifiedParameterName, String mixinId, String parameterName, ComponentModel model) {
        if (model.getSupportsInformalParameters()) {
            return new ParameterBinderImpl(mixinId, parameterName, null);
        }
        throw new TapestryException(String.format("Binding parameter %s as an informal parameter does not make sense, as %s does not support informal parameters.", qualifiedParameterName, model.getComponentClassName()), this.location, null);
    }

    private ParameterBinder createParameterBinderForComponent(String qualifiedParameterName, String parameterName) {
        ParameterBinder binder = this.getComponentAssembler().getBinder(parameterName);
        if (binder != null) {
            return binder;
        }
        return this.bindInformalParameter(qualifiedParameterName, null, parameterName, this.componentModel);
    }

    @Override
    public boolean isBound(String parameterName) {
        return InternalUtils.get(this.bound, (Object)parameterName) != null;
    }

    @Override
    public void setBound(String parameterName) {
        if (this.bound == null) {
            this.bound = CollectionFactory.newCaseInsensitiveMap();
        }
        this.bound.put(parameterName, true);
    }

    @Override
    public int addMixinsToElement(ComponentPageElement newElement) {
        for (Map.Entry<String, Instantiator> entry : this.mixinIdToInstantiator.entrySet()) {
            String mixinId = entry.getKey();
            Instantiator instantiator = entry.getValue();
            newElement.addMixin(mixinId, instantiator, this.mixinsIdToOrderConstraints.get(mixinId));
        }
        return this.mixinIdToInstantiator.size();
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public Set<String> getFormalParameterNames() {
        return new HashSet<String>(this.componentModel.getParameterNames());
    }
}

