/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.grid;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.SortConstraint;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionGridDataSource
implements GridDataSource {
    private final List list;

    public CollectionGridDataSource(Collection collection) {
        assert (collection != null);
        this.list = CollectionFactory.newList((Collection)collection);
    }

    @Override
    public int getAvailableRows() {
        return this.list.size();
    }

    @Override
    public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
        for (SortConstraint constraint : sortConstraints) {
            final ColumnSort sort = constraint.getColumnSort();
            if (sort == ColumnSort.UNSORTED) continue;
            final PropertyConduit conduit = constraint.getPropertyModel().getConduit();
            final Comparator<Comparable> valueComparator = new Comparator<Comparable>(){

                @Override
                public int compare(Comparable o1, Comparable o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    return o1.compareTo(o2);
                }
            };
            final Comparator rowComparator = new Comparator(){

                public int compare(Object row1, Object row2) {
                    Comparable value1 = (Comparable)conduit.get(row1);
                    Comparable value2 = (Comparable)conduit.get(row2);
                    return valueComparator.compare(value1, value2);
                }
            };
            Comparator reverseComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    int modifier = sort == ColumnSort.ASCENDING ? 1 : -1;
                    return modifier * rowComparator.compare(o1, o2);
                }
            };
            Collections.sort(this.list, reverseComparator);
        }
    }

    @Override
    public Class getRowType() {
        return this.list.isEmpty() ? null : this.list.get(0).getClass();
    }

    @Override
    public Object getRowValue(int index) {
        return this.list.get(index);
    }
}

