/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.bindings;

import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.internal.bindings.BindingsMessages;
import org.apache.tapestry5.internal.bindings.InvariantBinding;
import org.apache.tapestry5.internal.services.StringInterner;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.BindingFactory;
import org.apache.tapestry5.services.FieldValidatorSource;

public class ValidateBindingFactory
implements BindingFactory {
    private final FieldValidatorSource fieldValidatorSource;
    private final StringInterner interner;

    public ValidateBindingFactory(FieldValidatorSource fieldValidatorSource, StringInterner interner) {
        this.fieldValidatorSource = fieldValidatorSource;
        this.interner = interner;
    }

    public Binding newBinding(String description, ComponentResources container, ComponentResources component, final String expression, Location location) {
        Component fieldAsObject = component.getComponent();
        if (!Field.class.isInstance(fieldAsObject)) {
            throw new TapestryException(BindingsMessages.validateBindingForFieldsOnly(component), location, null);
        }
        final Field field = (Field)((Object)fieldAsObject);
        return new InvariantBinding(location, FieldValidator.class, this.interner.intern(description + ": " + expression)){

            public Object get() {
                return ValidateBindingFactory.this.fieldValidatorSource.createValidators(field, expression);
            }
        };
    }
}

