/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal;

import java.util.Formatter;
import java.util.List;
import org.apache.tapestry5.internal.SingleKeySymbolProvider;
import org.apache.tapestry5.internal.SyntheticModuleDef;
import org.apache.tapestry5.internal.SyntheticSymbolSourceContributionDef;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.IOCUtilities;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.RegistryBuilder;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ServiceActivity;
import org.apache.tapestry5.ioc.services.ServiceActivityScoreboard;
import org.apache.tapestry5.ioc.services.Status;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.services.TapestryModule;
import org.slf4j.Logger;

public class TapestryAppInitializer {
    private final Logger logger;
    private final SymbolProvider appProvider;
    private final String appName;
    private final long startTime;
    private final RegistryBuilder builder = new RegistryBuilder();
    private long registryCreatedTime;
    private Registry registry;

    public TapestryAppInitializer(Logger logger, String appPackage, String appName, String aliasMode) {
        this(logger, appPackage, appName);
    }

    public TapestryAppInitializer(Logger logger, String appPackage, String appName) {
        this(logger, new SingleKeySymbolProvider("tapestry.app-package", appPackage), appName, null);
    }

    public TapestryAppInitializer(Logger logger, SymbolProvider appProvider, String appName, String aliasMode, String executionModes) {
        this(logger, appProvider, appName, executionModes);
    }

    public TapestryAppInitializer(Logger logger, SymbolProvider appProvider, String appName, String executionModes) {
        this.logger = logger;
        this.appProvider = appProvider;
        String appPackage = appProvider.valueForSymbol("tapestry.app-package");
        this.appName = appName;
        this.startTime = System.currentTimeMillis();
        if (!Boolean.parseBoolean(appProvider.valueForSymbol("tapestry.disable-default-modules"))) {
            IOCUtilities.addDefaultModules((RegistryBuilder)this.builder);
        }
        this.addModules(TapestryModule.class);
        String className = appPackage + ".services." + InternalUtils.capitalize((String)this.appName) + "Module";
        try {
            Class<?> moduleClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            this.builder.add(new Class[]{moduleClass});
        }
        catch (ClassNotFoundException ex) {
            logger.warn("Application Module class {} not found", (Object)className);
        }
        this.addSyntheticSymbolSourceModule(appPackage);
        for (String mode : TapestryInternalUtils.splitAtCommas(executionModes)) {
            String key = String.format("tapestry.%s-modules", mode);
            String moduleList = appProvider.valueForSymbol(key);
            for (String moduleClassName : TapestryInternalUtils.splitAtCommas(moduleList)) {
                this.builder.add(moduleClassName);
            }
        }
    }

    public void addModules(ModuleDef ... moduleDefs) {
        for (ModuleDef def : moduleDefs) {
            this.builder.add(def);
        }
    }

    public void addModules(Class ... moduleClasses) {
        this.builder.add(moduleClasses);
    }

    private void addSyntheticSymbolSourceModule(String appPackage) {
        SyntheticSymbolSourceContributionDef appPathContribution = new SyntheticSymbolSourceContributionDef("AppPath", new SingleKeySymbolProvider("tapestry.app-package-path", appPackage.replace('.', '/')), new String[0]);
        SyntheticSymbolSourceContributionDef symbolSourceContribution = new SyntheticSymbolSourceContributionDef("ServletContext", this.appProvider, "before:ApplicationDefaults", "after:EnvironmentVariables");
        SyntheticSymbolSourceContributionDef appNameContribution = new SyntheticSymbolSourceContributionDef("AppName", new SingleKeySymbolProvider("tapestry.app-name", this.appName), "before:ServletContext");
        this.builder.add((ModuleDef)new SyntheticModuleDef(symbolSourceContribution, appNameContribution, appPathContribution));
    }

    public Registry createRegistry() {
        this.registryCreatedTime = System.currentTimeMillis();
        this.registry = this.builder.build();
        return this.registry;
    }

    public void announceStartup() {
        long toFinish = System.currentTimeMillis();
        SymbolSource source = (SymbolSource)this.registry.getService("SymbolSource", SymbolSource.class);
        StringBuilder buffer = new StringBuilder("Startup status:\n\nServices:\n\n");
        Formatter f = new Formatter(buffer);
        int unrealized = 0;
        ServiceActivityScoreboard scoreboard = (ServiceActivityScoreboard)this.registry.getService(ServiceActivityScoreboard.class);
        List serviceActivity = scoreboard.getServiceActivity();
        int longest = 0;
        for (ServiceActivity activity : serviceActivity) {
            Status status = activity.getStatus();
            longest = Math.max(longest, activity.getServiceId().length());
            if (status != Status.DEFINED && status != Status.VIRTUAL) continue;
            ++unrealized;
        }
        String formatString = "%" + longest + "s: %s\n";
        for (ServiceActivity activity : serviceActivity) {
            f.format(formatString, activity.getServiceId(), activity.getStatus().name());
        }
        f.format("\n%4.2f%% unrealized services (%d/%d)\n", 100.0 * (double)unrealized / (double)serviceActivity.size(), unrealized, serviceActivity.size());
        f.format("\nApplication '%s' (version %s) startup time: %,d ms to build IoC Registry, %,d ms overall.", this.appName, source.valueForSymbol("tapestry.application-version"), this.registryCreatedTime - this.startTime, toFinish - this.startTime);
        String version = source.valueForSymbol("tapestry.version");
        boolean productionMode = Boolean.parseBoolean(source.valueForSymbol("tapestry.production-mode"));
        buffer.append("\n\n");
        buffer.append(" ______                  __             ____\n");
        buffer.append("/_  __/__ ____  ___ ___ / /_______ __  / __/\n");
        buffer.append(" / / / _ `/ _ \\/ -_|_-</ __/ __/ // / /__ \\ \n");
        buffer.append("/_/  \\_,_/ .__/\\__/___/\\__/_/  \\_, / /____/\n");
        f.format("        /_/                   /___/  %s%s\n\n", version, productionMode ? "" : " (development mode)");
        this.logger.info(buffer.toString());
    }
}

