/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.BaseValidationDecorator;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;

public final class DefaultValidationDecorator
extends BaseValidationDecorator {
    private final Environment environment;
    private final Asset spacerAsset;
    private final MarkupWriter markupWriter;

    public DefaultValidationDecorator(Environment environment, Asset spacerAsset, MarkupWriter markupWriter) {
        this.environment = environment;
        this.spacerAsset = spacerAsset;
        this.markupWriter = markupWriter;
    }

    public void insideField(Field field) {
        if (this.inError(field)) {
            this.addErrorClassToCurrentElement();
        }
    }

    public void insideLabel(Field field, Element element) {
        if (field == null) {
            return;
        }
        if (this.inError(field)) {
            element.addClassName("t-error");
        }
    }

    public void afterField(Field field) {
        boolean inError = this.inError(field);
        boolean clientValidationEnabled = this.getFormSupport().isClientValidationEnabled();
        if (inError || clientValidationEnabled) {
            String iconId = field.getClientId() + "_icon";
            String cssClass = inError ? "t-error-icon" : "t-error-icon t-invisible";
            this.markupWriter.element("img", "src", this.spacerAsset.toClientURL(), "alt", "", "class", cssClass, "id", iconId);
            this.markupWriter.end();
        }
    }

    private FormSupport getFormSupport() {
        return this.environment.peekRequired(FormSupport.class);
    }

    private boolean inError(Field field) {
        ValidationTracker tracker = this.environment.peekRequired(ValidationTracker.class);
        return tracker.inError(field);
    }

    private void addErrorClassToCurrentElement() {
        this.markupWriter.getElement().addClassName("t-error");
    }
}

