/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.Block;
import org.apache.tapestry5.ClientBodyElement;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.corelib.internal.ComponentActionSink;
import org.apache.tapestry5.corelib.internal.FormSupportAdapter;
import org.apache.tapestry5.corelib.internal.HiddenFieldPositioner;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ClientBehaviorSupport;
import org.apache.tapestry5.services.ClientDataEncoder;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Heartbeat;
import org.apache.tapestry5.services.HiddenFieldLocationRules;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.slf4j.Logger;

@SupportsInformalParameters
public class Zone
implements ClientBodyElement {
    @Parameter(defaultPrefix="literal", value="symbol:tapestry.components.zone_show_method")
    private String show;
    @Parameter(defaultPrefix="literal", value="symbol:tapestry.components.zone_update_method")
    private String update;
    @Parameter(required=true, allowNull=false, defaultPrefix="literal")
    private String elementName;
    @Parameter(name="id", defaultPrefix="literal")
    private String idParameter;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Environmental
    private ClientBehaviorSupport clientBehaviorSupport;
    @Inject
    private Environment environment;
    @Parameter
    private boolean visible = true;
    @Inject
    private ComponentResources resources;
    @Inject
    private Heartbeat heartbeat;
    @Inject
    private Logger logger;
    @Inject
    private ClientDataEncoder clientDataEncoder;
    @Inject
    private HiddenFieldLocationRules rules;
    private String clientId;
    private boolean insideForm;
    private HiddenFieldPositioner hiddenFieldPositioner;
    private ComponentActionSink actionSink;

    String defaultElementName() {
        return this.resources.getElementName("div");
    }

    void beginRender(MarkupWriter writer) {
        this.clientId = this.resources.isBound("id") ? this.idParameter : this.javascriptSupport.allocateClientId(this.resources);
        Element e = writer.element(this.elementName, "id", this.clientId);
        this.resources.renderInformalParameters(writer);
        e.addClassName("t-zone");
        if (!this.visible) {
            e.addClassName("t-invisible");
        }
        this.clientBehaviorSupport.addZone(this.clientId, this.show, this.update);
        FormSupport existingFormSupport = this.environment.peek(FormSupport.class);
        boolean bl = this.insideForm = existingFormSupport != null;
        if (this.insideForm) {
            this.hiddenFieldPositioner = new HiddenFieldPositioner(writer, this.rules);
            this.actionSink = new ComponentActionSink(this.logger, this.clientDataEncoder);
            this.environment.push(FormSupport.class, new FormSupportAdapter(existingFormSupport){

                @Override
                public <T> void store(T component, ComponentAction<T> action) {
                    Zone.this.actionSink.store(component, action);
                }

                @Override
                public <T> void storeAndExecute(T component, ComponentAction<T> action) {
                    this.store(component, action);
                    action.execute(component);
                }
            });
        }
        this.heartbeat.begin();
    }

    void afterRender(MarkupWriter writer) {
        this.heartbeat.end();
        if (this.insideForm) {
            this.environment.pop(FormSupport.class);
            if (this.actionSink.isEmpty()) {
                this.hiddenFieldPositioner.discard();
            } else {
                this.hiddenFieldPositioner.getElement().attributes("type", "hidden", "name", "t:formdata", "value", this.actionSink.getClientData());
            }
        }
        writer.end();
    }

    public String getClientId() {
        if (this.resources.isBound("id")) {
            return this.idParameter;
        }
        return this.clientId;
    }

    public Block getBody() {
        return this.resources.getBody();
    }
}

