/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.TrackableComponentEventCallback;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.corelib.SubmitMode;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Heartbeat;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class Submit
implements ClientElement {
    @Parameter
    private boolean defer = true;
    @Parameter(allowNull=false, defaultPrefix="literal")
    private String event = "selected";
    @Parameter(value="false")
    private boolean disabled;
    @Parameter
    private Object[] context;
    @Parameter(defaultPrefix="asset")
    private Asset image;
    @Parameter(allowNull=false, defaultPrefix="literal")
    private SubmitMode mode = SubmitMode.NORMAL;
    @Environmental
    private FormSupport formSupport;
    @Environmental
    private Heartbeat heartbeat;
    @Inject
    private ComponentResources resources;
    @Inject
    private Request request;
    @Inject
    private JavaScriptSupport javascriptSupport;
    @Environmental
    private TrackableComponentEventCallback eventCallback;
    private String clientId;

    public Submit() {
    }

    Submit(Request request) {
        this.request = request;
    }

    void beginRender(MarkupWriter writer) {
        this.clientId = this.javascriptSupport.allocateClientId(this.resources);
        boolean isCancel = this.mode == SubmitMode.CANCEL;
        String name = isCancel ? "cancel" : this.formSupport.allocateControlName(this.resources.getId());
        String type = this.image == null ? "submit" : "image";
        writer.element("input", "type", type, "name", name, "id", this.clientId);
        if (this.disabled) {
            writer.attributes("disabled", "disabled");
        }
        if (this.image != null) {
            writer.attributes("src", this.image.toClientURL());
        }
        this.formSupport.store(this, new ProcessSubmission(this.clientId, name));
        this.resources.renderInformalParameters(writer);
        if (this.mode != SubmitMode.NORMAL) {
            this.javascriptSupport.addInitializerCall("enableBypassValidation", this.getClientId());
        }
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    void processSubmission(String clientId, String elementName) {
        if (this.disabled || !this.selected(clientId, elementName)) {
            return;
        }
        Runnable sendNotification = new Runnable(){

            public void run() {
                Submit.this.resources.triggerEvent(Submit.this.event, Submit.this.context, Submit.this.eventCallback);
            }
        };
        if (this.defer) {
            this.formSupport.defer(sendNotification);
        } else {
            this.heartbeat.defer(sendNotification);
        }
    }

    private boolean selected(String clientId, String elementName) {
        String raw = this.request.getParameter("t:submit");
        if (InternalUtils.isNonBlank((String)raw) && new JSONArray(raw).getString(0).equals(clientId)) {
            return true;
        }
        String name = this.image == null ? elementName : elementName + ".x";
        String value = this.request.getParameter(name);
        return value != null;
    }

    public String getClientId() {
        return this.clientId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessSubmission
    implements ComponentAction<Submit> {
        private final String clientId;
        private final String elementName;

        public ProcessSubmission(String clientId, String elementName) {
            this.clientId = clientId;
            this.elementName = elementName;
        }

        @Override
        public void execute(Submit component) {
            component.processSubmission(this.clientId, this.elementName);
        }
    }
}

