/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.List;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.GridModel;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.FormSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridRows {
    private int startRow;
    private boolean recordStateByIndex;
    private boolean recordStateByEncoder;
    @Parameter(cache=false)
    private String rowClass;
    @Parameter(value="componentResources.container")
    private GridModel gridModel;
    @Parameter(required=true, allowNull=false)
    @Property
    private PropertyOverrides overrides;
    @Parameter(required=true)
    private int rowsPerPage;
    @Parameter(required=true)
    private int currentPage;
    @Parameter(required=true)
    @Property(write=false)
    private Object row;
    @Parameter
    private boolean lean;
    @Parameter(name="volatile")
    private boolean volatileState;
    @Parameter
    private ValueEncoder encoder;
    @Parameter
    private int rowIndex;
    @Parameter
    @Property
    private int columnIndex;
    @Environmental(value=false)
    private FormSupport formSupport;
    private int endRow;
    private int dataRowIndex;
    private String propertyName;
    @Property(write=false)
    private PropertyModel columnModel;

    public String getRowClass() {
        List classes = CollectionFactory.newList();
        String rc = this.rowClass;
        if (rc != null) {
            classes.add(rc);
        }
        if (this.dataRowIndex == this.startRow) {
            classes.add("t-first");
        }
        if (this.dataRowIndex == this.endRow) {
            classes.add("t-last");
        }
        return TapestryInternalUtils.toClassAttributeValue(classes);
    }

    public String getCellClass() {
        List classes = CollectionFactory.newList();
        String id = this.gridModel.getDataModel().get(this.propertyName).getId();
        if (!this.lean) {
            classes.add(id);
            switch (this.gridModel.getSortModel().getColumnSort(id)) {
                case ASCENDING: {
                    classes.add("t-sort-column-ascending");
                    break;
                }
                case DESCENDING: {
                    classes.add("t-sort-column-descending");
                    break;
                }
            }
        }
        return TapestryInternalUtils.toClassAttributeValue(classes);
    }

    void setupRender() {
        GridDataSource dataSource = this.gridModel.getDataSource();
        int availableRows = dataSource.getAvailableRows();
        int maxPages = (availableRows - 1) / this.rowsPerPage + 1;
        if (this.currentPage > maxPages) {
            this.currentPage = maxPages;
        }
        this.startRow = (this.currentPage - 1) * this.rowsPerPage;
        this.endRow = Math.min(availableRows - 1, this.startRow + this.rowsPerPage - 1);
        this.dataRowIndex = this.startRow;
        boolean recordingStateInsideForm = !this.volatileState && this.formSupport != null;
        this.recordStateByIndex = recordingStateInsideForm && this.encoder == null;
        this.recordStateByEncoder = recordingStateInsideForm && this.encoder != null;
    }

    void setupForRow(int rowIndex) {
        this.row = this.gridModel.getDataSource().getRowValue(rowIndex);
    }

    void setupForRowWithClientValue(String clientValue) {
        this.row = this.encoder.toValue(clientValue);
        if (this.row == null) {
            throw new IllegalArgumentException(String.format("%s returned null for client value '%s'.", this.encoder, clientValue));
        }
    }

    boolean beginRender() {
        this.setupForRow(this.dataRowIndex);
        this.rowIndex = this.dataRowIndex - this.startRow;
        if (this.row != null) {
            if (this.recordStateByIndex) {
                this.formSupport.store(this, new SetupForRowByIndex(this.dataRowIndex));
            }
            if (this.recordStateByEncoder) {
                String key = this.encoder.toClient(this.row);
                this.formSupport.store(this, new SetupForRowWithClientValue(key));
            }
        }
        return this.row != null;
    }

    boolean afterRender() {
        ++this.dataRowIndex;
        return this.row == null || this.dataRowIndex > this.endRow;
    }

    public List<String> getPropertyNames() {
        return this.gridModel.getDataModel().getPropertyNames();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        this.columnModel = this.gridModel.getDataModel().get(propertyName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SetupForRowWithClientValue
    implements ComponentAction<GridRows> {
        private final String clientValue;

        SetupForRowWithClientValue(String clientValue) {
            this.clientValue = clientValue;
        }

        @Override
        public void execute(GridRows component) {
            component.setupForRowWithClientValue(this.clientValue);
        }

        public String toString() {
            return String.format("GridRows.SetupForRowWithClientValue[%s]", this.clientValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SetupForRowByIndex
    implements ComponentAction<GridRows> {
        private static final long serialVersionUID = -3216282071752371975L;
        private final int rowIndex;

        public SetupForRowByIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Override
        public void execute(GridRows component) {
            component.setupForRow(this.rowIndex);
        }

        public String toString() {
            return String.format("GridRows.SetupForRowByIndex[%d]", this.rowIndex);
        }
    }
}

