/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FormValidationControl;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.TrackableComponentEventCallback;
import org.apache.tapestry5.ValidationDecorator;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.ValidationTrackerImpl;
import org.apache.tapestry5.ValidationTrackerWrapper;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.HeartbeatDeferred;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.corelib.ClientValidation;
import org.apache.tapestry5.corelib.internal.ComponentActionSink;
import org.apache.tapestry5.corelib.internal.FormSupportImpl;
import org.apache.tapestry5.corelib.internal.InternalFormSupport;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.internal.BeanValidationContext;
import org.apache.tapestry5.internal.BeanValidationContextImpl;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.HeartbeatImpl;
import org.apache.tapestry5.internal.util.AutofocusValidationDecorator;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.apache.tapestry5.ioc.util.IdAllocator;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.runtime.ComponentResourcesAware;
import org.apache.tapestry5.services.ClientBehaviorSupport;
import org.apache.tapestry5.services.ClientDataEncoder;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Heartbeat;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.slf4j.Logger;

@SupportsInformalParameters
public class Form
implements ClientElement,
FormValidationControl {
    public static final String FORM_DATA = "t:formdata";
    public static final String SUBMITTING_ELEMENT_ID = "t:submit";
    @Parameter
    private Object[] context;
    @Parameter(value="defaultTracker")
    private ValidationTracker tracker;
    @Inject
    @Symbol(value="tapestry.form-client-logic-enabled")
    private boolean clientLogicDefaultEnabled;
    @Parameter(allowNull=false, defaultPrefix="literal")
    private ClientValidation clientValidation;
    @Parameter
    private boolean autofocus;
    @Parameter(defaultPrefix="literal")
    private String zone;
    @Parameter
    private boolean secure;
    @Parameter
    private String validationId;
    @Parameter
    private Object validate;
    @Inject
    private Logger logger;
    @Inject
    private Environment environment;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Environmental
    private JavaScriptSupport jsSupport;
    @Inject
    private Request request;
    @Inject
    private ComponentSource source;
    @Inject
    @Symbol(value="tapestry.pre-selected-form-names")
    private String preselectedFormNames;
    @Persist(value="flash")
    private ValidationTracker defaultTracker;
    @Inject
    @Symbol(value="tapestry.secure-enabled")
    private boolean secureEnabled;
    private InternalFormSupport formSupport;
    private Element form;
    private Element div;
    private ComponentActionSink actionSink;
    @Environmental
    private ClientBehaviorSupport clientBehaviorSupport;
    @Environmental
    private TrackableComponentEventCallback eventCallback;
    @Inject
    private ClientDataEncoder clientDataEncoder;
    @Inject
    private PropertyAccess propertyAccess;
    private String clientId;
    private ValidationTracker activeTracker;
    @Inject
    private ComponentSource componentSource;

    public Form() {
        this.clientValidation = this.clientLogicDefaultEnabled ? ClientValidation.BLUR : ClientValidation.NONE;
        this.autofocus = this.clientLogicDefaultEnabled;
    }

    String defaultValidationId() {
        return this.resources.getId();
    }

    Object defaultValidate() {
        return this.resources.getContainer();
    }

    private ValidationTracker getWrappedTracker() {
        ValidationTracker innerTracker = this.tracker == null ? new ValidationTrackerImpl() : this.tracker;
        ValidationTrackerWrapper wrapper = new ValidationTrackerWrapper(innerTracker){
            private boolean saved;
            {
                this.saved = false;
            }

            private void save() {
                if (!this.saved) {
                    Form.this.tracker = this.getDelegate();
                    this.saved = true;
                }
            }

            public void recordError(Field field, String errorMessage) {
                super.recordError(field, errorMessage);
                this.save();
            }

            public void recordError(String errorMessage) {
                super.recordError(errorMessage);
                this.save();
            }
        };
        return wrapper;
    }

    public ValidationTracker getDefaultTracker() {
        return this.defaultTracker;
    }

    public void setDefaultTracker(ValidationTracker defaultTracker) {
        this.defaultTracker = defaultTracker;
    }

    void setupRender() {
        FormSupport existing = this.environment.peek(FormSupport.class);
        if (existing != null) {
            throw new TapestryException(this.messages.get("nesting-not-allowed"), (Object)existing, null);
        }
    }

    void beginRender(MarkupWriter writer) {
        Link link = this.resources.createFormEventLink("action", this.context);
        String actionURL = this.secure && this.secureEnabled ? link.toAbsoluteURI(true) : link.toURI();
        this.actionSink = new ComponentActionSink(this.logger, this.clientDataEncoder);
        this.clientId = this.javascriptSupport.allocateClientId(this.resources);
        IdAllocator allocator = new IdAllocator();
        this.preallocateNames(allocator);
        this.formSupport = this.createRenderTimeFormSupport(this.clientId, this.actionSink, allocator);
        this.addJavaScriptInitialization();
        if (this.zone != null) {
            this.linkFormToZone(link);
        }
        this.activeTracker = this.getWrappedTracker();
        this.environment.push(FormSupport.class, this.formSupport);
        this.environment.push(ValidationTracker.class, this.activeTracker);
        if (this.autofocus) {
            AutofocusValidationDecorator autofocusDecorator = new AutofocusValidationDecorator(this.environment.peek(ValidationDecorator.class), this.activeTracker, this.jsSupport);
            this.environment.push(ValidationDecorator.class, autofocusDecorator);
        }
        this.resources.triggerEvent("prepareForRender", this.context, null);
        this.resources.triggerEvent("prepare", this.context, null);
        this.environment.push(BeanValidationContext.class, new BeanValidationContextImpl(this.validate));
        this.form = writer.element("form", "id", this.clientId, "method", "post", "action", actionURL);
        if (!(this.zone == null && this.clientValidation == ClientValidation.NONE || this.request.isXHR())) {
            writer.attributes("onsubmit", "javascript:return Tapestry.waitForPage(event);");
        }
        this.resources.renderInformalParameters(writer);
        this.div = writer.element("div", "class", "t-invisible");
        for (String parameterName : link.getParameterNames()) {
            String[] values;
            for (String value : values = link.getParameterValues(parameterName)) {
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.error(String.format("Enable to decode parameter value for parameter %s in form %s", parameterName, this.form.getName()), (Throwable)e);
                }
                writer.element("input", "type", "hidden", "name", parameterName, "value", value);
                writer.end();
            }
        }
        writer.end();
        this.environment.peek(Heartbeat.class).begin();
    }

    private void addJavaScriptInitialization() {
        JSONObject validateSpec = new JSONObject().put("blur", (Object)(this.clientValidation == ClientValidation.BLUR ? 1 : 0)).put("submit", (Object)(this.clientValidation != ClientValidation.NONE ? 1 : 0));
        JSONObject spec = new JSONObject(new String[]{"formId", this.clientId}).put("validate", (Object)validateSpec);
        this.javascriptSupport.addInitializerCall(InitializationPriority.EARLY, "formEventManager", spec);
    }

    @HeartbeatDeferred
    private void linkFormToZone(Link link) {
        this.clientBehaviorSupport.linkZone(this.clientId, this.zone, link);
    }

    @OnEvent(value="internalCreateRenderTimeFormSupport")
    InternalFormSupport createRenderTimeFormSupport(String clientId, ComponentActionSink actionSink, IdAllocator allocator) {
        return new FormSupportImpl(this.resources, clientId, actionSink, this.clientBehaviorSupport, this.clientValidation != ClientValidation.NONE, allocator, this.validationId);
    }

    void afterRender(MarkupWriter writer) {
        this.environment.peek(Heartbeat.class).end();
        this.formSupport.executeDeferred();
        String encodingType = this.formSupport.getEncodingType();
        if (encodingType != null) {
            this.form.forceAttributes("enctype", encodingType);
        }
        writer.end();
        this.div.element("input", "type", "hidden", "name", FORM_DATA, "value", this.actionSink.getClientData());
        if (this.autofocus) {
            this.environment.pop(ValidationDecorator.class);
        }
    }

    void cleanupRender() {
        this.environment.pop(FormSupport.class);
        this.formSupport = null;
        this.environment.pop(ValidationTracker.class);
        this.activeTracker = null;
        this.environment.pop(BeanValidationContext.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Log
    Object onAction(EventContext context) throws IOException {
        this.activeTracker = this.getWrappedTracker();
        this.activeTracker.clear();
        this.formSupport = new FormSupportImpl(this.resources, this.validationId);
        this.environment.push(ValidationTracker.class, this.activeTracker);
        this.environment.push(FormSupport.class, this.formSupport);
        HeartbeatImpl heartbeat = new HeartbeatImpl();
        this.environment.push(Heartbeat.class, heartbeat);
        heartbeat.begin();
        boolean didPushBeanValidationContext = false;
        try {
            this.resources.triggerContextEvent("prepareForSubmit", context, this.eventCallback);
            if (this.eventCallback.isAborted()) {
                Boolean bl = true;
                return bl;
            }
            this.resources.triggerContextEvent("prepare", context, this.eventCallback);
            if (this.eventCallback.isAborted()) {
                Boolean bl = true;
                return bl;
            }
            if (this.isFormCancelled()) {
                this.resources.triggerContextEvent("canceled", context, this.eventCallback);
                if (this.eventCallback.isAborted()) {
                    Boolean bl = true;
                    return bl;
                }
            }
            this.environment.push(BeanValidationContext.class, new BeanValidationContextImpl(this.validate));
            didPushBeanValidationContext = true;
            this.executeStoredActions();
            heartbeat.end();
            this.formSupport.executeDeferred();
            this.fireValidateEvent("validate", context, this.eventCallback);
            if (this.eventCallback.isAborted()) {
                Boolean bl = true;
                return bl;
            }
            if (!this.activeTracker.getHasErrors()) {
                this.activeTracker.clear();
            }
            this.resources.triggerContextEvent(this.activeTracker.getHasErrors() ? "failure" : "success", context, this.eventCallback);
            if (this.eventCallback.isAborted()) {
                Boolean bl = true;
                return bl;
            }
            this.resources.triggerContextEvent("submit", context, this.eventCallback);
            Boolean bl = this.eventCallback.isAborted();
            return bl;
        }
        finally {
            this.environment.pop(Heartbeat.class);
            this.environment.pop(FormSupport.class);
            this.environment.pop(ValidationTracker.class);
            if (didPushBeanValidationContext) {
                this.environment.pop(BeanValidationContext.class);
            }
            this.activeTracker = null;
        }
    }

    private boolean isFormCancelled() {
        if (this.request.getParameter("cancel") != null || this.request.getParameter("cancel.x") != null) {
            return true;
        }
        String raw = this.request.getParameter(SUBMITTING_ELEMENT_ID);
        return InternalUtils.isNonBlank((String)raw) && new JSONArray(raw).getString(1).equals("cancel");
    }

    private void fireValidateEvent(String eventName, EventContext context, TrackableComponentEventCallback callback) {
        try {
            this.resources.triggerContextEvent(eventName, context, callback);
        }
        catch (RuntimeException ex) {
            ValidationException ve = (ValidationException)ExceptionUtils.findCause((Throwable)ex, ValidationException.class, (PropertyAccess)this.propertyAccess);
            if (ve != null) {
                ValidationTracker tracker = this.environment.peek(ValidationTracker.class);
                tracker.recordError(ve.getMessage());
                return;
            }
            throw ex;
        }
    }

    /*
     * Loose catch block
     */
    private void executeStoredActions() {
        String[] values = this.request.getParameters(FORM_DATA);
        if (!this.request.getMethod().equals("POST") || values == null) {
            throw new RuntimeException(this.messages.format("invalid-request", new Object[]{FORM_DATA}));
        }
        for (String clientEncodedActions : values) {
            if (InternalUtils.isBlank((String)clientEncodedActions)) continue;
            this.logger.debug("Processing actions: {}", (Object)clientEncodedActions);
            ObjectInputStream ois = null;
            ComponentResourcesAware component = null;
            try {
                ois = this.clientDataEncoder.decodeClientData(clientEncodedActions);
                while (!this.eventCallback.isAborted()) {
                    String componentId = ois.readUTF();
                    ComponentAction action = (ComponentAction)ois.readObject();
                    component = this.source.getComponent(componentId);
                    this.logger.debug("Processing: {} {}", (Object)componentId, (Object)action);
                    action.execute(component);
                    component = null;
                }
            }
            catch (EOFException ex) {
                InternalUtils.close((Closeable)ois);
                continue;
            }
            catch (Exception ex2) {
                Location location = component == null ? null : component.getComponentResources().getLocation();
                throw new TapestryException(ex2.getMessage(), location, (Throwable)ex2);
                {
                    catch (Throwable throwable) {
                        InternalUtils.close(ois);
                        throw throwable;
                    }
                }
            }
            InternalUtils.close((Closeable)ois);
        }
    }

    public void recordError(String errorMessage) {
        this.getActiveTracker().recordError(errorMessage);
    }

    public void recordError(Field field, String errorMessage) {
        this.getActiveTracker().recordError(field, errorMessage);
    }

    public boolean getHasErrors() {
        return this.getActiveTracker().getHasErrors();
    }

    public boolean isValid() {
        return !this.getActiveTracker().getHasErrors();
    }

    private ValidationTracker getActiveTracker() {
        return this.activeTracker != null ? this.activeTracker : this.getWrappedTracker();
    }

    public void clearErrors() {
        this.getActiveTracker().clear();
    }

    void setTracker(ValidationTracker tracker) {
        this.tracker = tracker;
    }

    public String getClientId() {
        return this.clientId;
    }

    private void preallocateNames(IdAllocator idAllocator) {
        for (String name : TapestryInternalUtils.splitAtCommas(this.preselectedFormNames)) {
            idAllocator.allocateId(name);
            this.javascriptSupport.allocateClientId(name);
        }
        Component activePage = this.componentSource.getActivePage();
        if (activePage == null) {
            return;
        }
        ComponentResources activePageResources = activePage.getComponentResources();
        try {
            activePageResources.triggerEvent("preallocateFormControlNames", new Object[]{idAllocator}, null);
        }
        catch (RuntimeException ex) {
            this.logger.error(String.format("Unable to obtrain form control names to preallocate: %s", InternalUtils.toMessage((Throwable)ex)), (Throwable)ex);
        }
    }
}

