/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.alerts.Alert;
import org.apache.tapestry5.alerts.AlertStorage;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.HeartbeatDeferred;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class Alerts
implements ClientElement {
    @Parameter(value="message:dismiss-label", defaultPrefix="literal")
    private String dismissText;
    @Inject
    private ComponentResources resources;
    @Environmental
    private JavaScriptSupport javaScriptSupport;
    @SessionState(create=false)
    private AlertStorage storage;
    private String clientId;

    public String getClientId() {
        return this.clientId;
    }

    boolean beginRender(MarkupWriter writer) {
        this.clientId = this.javaScriptSupport.allocateClientId(this.resources);
        writer.element("div", "id", this.clientId);
        this.resources.renderInformalParameters(writer);
        writer.end();
        JSONObject spec = new JSONObject(new String[]{"id", this.clientId, "dismissURL", this.resources.createEventLink("dismiss", new Object[0]).toURI(), "dismissText", this.dismissText});
        this.javaScriptSupport.addInitializerCall(InitializationPriority.EARLY, "alertManager", spec);
        if (this.storage != null) {
            this.addAlertsFromStorage();
        }
        return false;
    }

    Object onDismiss(@RequestParameter(value="id", allowBlank=true) Long alertId) {
        if (this.storage != null) {
            if (alertId != null) {
                this.storage.dismiss(alertId);
            } else {
                this.storage.dismissAll();
            }
        }
        return new JSONObject();
    }

    @HeartbeatDeferred
    void addAlertsFromStorage() {
        for (Alert alert : this.storage.getAlerts()) {
            this.javaScriptSupport.addInitializerCall("addAlert", alert.toJSON());
        }
        this.storage.dismissNonPersistent();
    }
}

