/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.alerts;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tapestry5.alerts.Duration;
import org.apache.tapestry5.alerts.Severity;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.json.JSONObject;

public class Alert
implements Serializable {
    private static final AtomicLong idSource = new AtomicLong(System.currentTimeMillis());
    public final long id = idSource.getAndIncrement();
    public final Duration duration;
    public final Severity severity;
    public final String message;

    public Alert(String message) {
        this(Severity.INFO, message);
    }

    public Alert(Severity severity, String message) {
        this(Duration.SINGLE, severity, message);
    }

    public Alert(Duration duration, Severity severity, String message) {
        assert (duration != null);
        assert (severity != null);
        assert (InternalUtils.isNonBlank((String)message));
        this.duration = duration;
        this.severity = severity;
        this.message = message;
    }

    public String toString() {
        return String.format("Alert[%s %s %s]", this.duration.name(), this.severity.name(), this.message);
    }

    public JSONObject toJSON() {
        JSONObject result = new JSONObject(new String[]{"message", this.message, "class", this.severity.cssClass});
        if (this.duration == Duration.TRANSIENT) {
            result.put("transient", (Object)true);
        }
        if (this.duration.persistent) {
            result.put("id", (Object)this.id);
        }
        return result;
    }
}

