/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tapestry5.internal.ServletContextSymbolProvider;
import org.apache.tapestry5.internal.TapestryAppInitializer;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.internal.services.SystemPropertiesSymbolProvider;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.services.HttpServletRequestHandler;
import org.apache.tapestry5.services.ServletApplicationInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapestryFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(TapestryFilter.class);
    private FilterConfig config;
    private Registry registry;
    private HttpServletRequestHandler handler;
    public static final String REGISTRY_CONTEXT_NAME = "org.apache.tapestry5.application-registry";

    public final void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        final ServletContext context = this.config.getServletContext();
        String filterName = this.config.getFilterName();
        SymbolProvider provider = new SymbolProvider(){
            SymbolProvider contextProvider;
            SymbolProvider systemProvider;
            {
                this.contextProvider = new ServletContextSymbolProvider(context);
                this.systemProvider = new SystemPropertiesSymbolProvider();
            }

            public String valueForSymbol(String symbolName) {
                String contextValue = this.contextProvider.valueForSymbol(symbolName);
                if (contextValue != null) {
                    return contextValue;
                }
                return this.systemProvider.valueForSymbol(symbolName);
            }
        };
        String executionMode = System.getProperty("tapestry.execution-mode", "production");
        TapestryAppInitializer appInitializer = new TapestryAppInitializer(this.logger, provider, filterName, executionMode);
        appInitializer.addModules(this.provideExtraModuleDefs(context));
        appInitializer.addModules(this.provideExtraModuleClasses(context));
        this.registry = appInitializer.createRegistry();
        context.setAttribute(REGISTRY_CONTEXT_NAME, (Object)this.registry);
        ServletApplicationInitializer ai = (ServletApplicationInitializer)this.registry.getService("ServletApplicationInitializer", ServletApplicationInitializer.class);
        ai.initializeApplication(filterConfig.getServletContext());
        this.registry.performRegistryStartup();
        this.handler = (HttpServletRequestHandler)this.registry.getService("HttpServletRequestHandler", HttpServletRequestHandler.class);
        this.init(this.registry);
        appInitializer.announceStartup();
    }

    protected final FilterConfig getFilterConfig() {
        return this.config;
    }

    protected void init(Registry registry) throws ServletException {
    }

    protected ModuleDef[] provideExtraModuleDefs(ServletContext context) {
        return new ModuleDef[0];
    }

    protected Class[] provideExtraModuleClasses(ServletContext context) {
        return new Class[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            boolean handled = this.handler.service((HttpServletRequest)request, (HttpServletResponse)response);
            if (!handled) {
                chain.doFilter(request, response);
            }
        }
        finally {
            this.registry.cleanupThread();
        }
    }

    public final void destroy() {
        this.destroy(this.registry);
        this.registry.shutdown();
        this.config.getServletContext().removeAttribute(REGISTRY_CONTEXT_NAME);
        this.registry = null;
        this.config = null;
        this.handler = null;
    }

    protected void destroy(Registry registry) {
    }
}

