/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.util.UtilMessages;

public class TimeInterval {
    private static final Map<String, Long> UNITS = CollectionFactory.newCaseInsensitiveMap();
    private static final long MILLISECOND = 1000L;
    private static final String[] UNIT_KEYS;
    private static final Pattern PATTERN;
    private final long milliseconds;

    public TimeInterval(String input) {
        this(TimeInterval.parseMilliseconds(input));
    }

    public TimeInterval(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public long milliseconds() {
        return this.milliseconds;
    }

    public long seconds() {
        return this.milliseconds / 1000L;
    }

    public String toDescription() {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        long remainder = this.milliseconds;
        for (String key : UNIT_KEYS) {
            if (remainder == 0L) break;
            long value = UNITS.get(key);
            long units = remainder / value;
            if (units <= 0L) continue;
            builder.append(sep);
            builder.append(units);
            builder.append(key);
            sep = " ";
            remainder %= value;
        }
        return builder.toString();
    }

    static long parseMilliseconds(String input) {
        long milliseconds = 0L;
        Matcher matcher = PATTERN.matcher(input);
        matcher.useAnchoringBounds(true);
        int lastMatchEnd = -1;
        while (matcher.find()) {
            int start = matcher.start();
            if (lastMatchEnd + 1 < start) {
                String invalid = input.substring(lastMatchEnd + 1, start);
                throw new RuntimeException(UtilMessages.invalidTimeIntervalInput(invalid, input));
            }
            lastMatchEnd = matcher.end();
            long count = Long.parseLong(matcher.group(1));
            String units = matcher.group(2);
            if (units.length() == 0) {
                milliseconds += count;
                continue;
            }
            Long unitValue = UNITS.get(units);
            if (unitValue == null) {
                throw new RuntimeException(UtilMessages.invalidTimeIntervalUnit(units, input, UNITS.keySet()));
            }
            milliseconds += count * unitValue;
        }
        if (lastMatchEnd + 1 < input.length()) {
            String invalid = input.substring(lastMatchEnd + 1);
            throw new RuntimeException(UtilMessages.invalidTimeIntervalInput(invalid, input));
        }
        return milliseconds;
    }

    public String toString() {
        return String.format("TimeInterval[%d ms]", this.milliseconds);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof TimeInterval) {
            TimeInterval tp = (TimeInterval)obj;
            return this.milliseconds == tp.milliseconds;
        }
        return false;
    }

    static {
        UNITS.put("ms", 1L);
        UNITS.put("s", 1000L);
        UNITS.put("m", 60000L);
        UNITS.put("h", 60L * UNITS.get("m"));
        UNITS.put("d", 24L * UNITS.get("h"));
        UNITS.put("y", 365L * UNITS.get("d"));
        UNIT_KEYS = new String[]{"y", "d", "h", "m", "s", "ms"};
        PATTERN = Pattern.compile("\\s*(\\d+)\\s*([a-z]*)", 2);
    }
}

