/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.Method;
import java.util.Set;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.def.ServiceDef3;
import org.apache.tapestry5.ioc.internal.ObjectCreatorSource;
import org.apache.tapestry5.ioc.internal.services.AnnotationProviderChain;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDefImpl
implements ServiceDef3 {
    private final Class serviceInterface;
    private final Class serviceImplementation;
    private final String serviceId;
    private final String scope;
    private final boolean eagerLoad;
    private final ObjectCreatorSource source;
    private final Set<Class> markers;
    private final boolean preventDecoration;

    ServiceDefImpl(Class serviceInterface, Class serviceImplementation, String serviceId, Set<Class> markers, String scope, boolean eagerLoad, boolean preventDecoration, ObjectCreatorSource source) {
        this.serviceInterface = serviceInterface;
        this.serviceImplementation = serviceImplementation;
        this.serviceId = serviceId;
        this.scope = scope;
        this.eagerLoad = eagerLoad;
        this.preventDecoration = preventDecoration;
        this.source = source;
        this.markers = markers;
    }

    public String toString() {
        return this.source.getDescription();
    }

    @Override
    public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
        return this.source.constructCreator(resources);
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    @Override
    public String getServiceScope() {
        return this.scope;
    }

    @Override
    public boolean isEagerLoad() {
        return this.eagerLoad;
    }

    @Override
    public Set<Class> getMarkers() {
        return this.markers;
    }

    @Override
    public boolean isPreventDecoration() {
        return this.preventDecoration;
    }

    private Flow<Class> searchPath() {
        return (Flow)F.flow((Object[])new Class[]{this.serviceImplementation, this.serviceInterface}).removeNulls();
    }

    @Override
    public AnnotationProvider getClassAnnotationProvider() {
        return AnnotationProviderChain.create(this.searchPath().map(InternalUtils.CLASS_TO_AP_MAPPER).toList());
    }

    @Override
    public AnnotationProvider getMethodAnnotationProvider(final String methodName, final Class ... argumentTypes) {
        return AnnotationProviderChain.create(this.searchPath().map((Mapper)new Mapper<Class, Method>(){

            public Method map(Class element) {
                return InternalUtils.findMethod(element, methodName, argumentTypes);
            }
        }).map(InternalUtils.METHOD_TO_AP_MAPPER).toList());
    }
}

