/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RandomDataSource {
    private final Random random = new Random(System.currentTimeMillis());
    private final List<String> words = new ArrayList<String>();

    public RandomDataSource() {
        int i;
        for (i = 0; i < 4; ++i) {
            this.readWords("english." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.readWords("american." + i);
        }
        System.out.printf("Dictionary contains %d words\n", this.words.size());
    }

    private void readWords(String name) {
        System.out.println("Reading " + name + " ...");
        int count = 0;
        InputStream is = this.getClass().getResourceAsStream(name);
        if (is == null) {
            throw new RuntimeException(String.format("File '%s' not found.", name));
        }
        try {
            String word;
            BufferedInputStream bis = new BufferedInputStream(is);
            InputStreamReader isr = new InputStreamReader(bis);
            LineNumberReader r = new LineNumberReader(isr);
            while ((word = r.readLine()) != null) {
                ++count;
                this.words.add(word);
            }
            r.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Error reading '%s': %s", name + ex.getMessage()), ex);
        }
        System.out.printf("... %d words\n", count);
    }

    public boolean maybe(int percent) {
        assert (percent > 0 && percent <= 100);
        return this.random.nextInt(100) < percent;
    }

    public int random(int min, int max) {
        assert (min <= max);
        return this.random.nextInt(max - min + 1) + min;
    }

    public String word() {
        int index = this.random.nextInt(this.words.size());
        return this.words.get(index);
    }

    public String capitalizedWord() {
        String word = this.word();
        char[] chars = word.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public String safeWord() {
        String word = this.word();
        int x = word.indexOf(39);
        return x < 0 ? word : word.substring(0, x);
    }

    public <T> T oneOf(T ... values) {
        assert (values.length > 0);
        int index = this.random.nextInt(values.length);
        return values[index];
    }

    public <T extends Enum> T oneOf(Class<T> enumClass) {
        return (T)((Enum)this.oneOf(enumClass.getEnumConstants()));
    }

    public String wordList(int minWords, int maxWords, boolean asSentence) {
        assert (minWords <= maxWords);
        assert (minWords > 0);
        StringBuilder builder = new StringBuilder();
        int count = this.random(minWords, maxWords);
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                builder.append(' ');
            }
            if (i == 0 && asSentence) {
                builder.append(this.capitalizedWord());
                continue;
            }
            builder.append(this.word());
        }
        if (asSentence) {
            builder.append('.');
        }
        return builder.toString();
    }

    public String paragraph(int minSentences, int maxSentences, int minWords, int maxWords) {
        assert (minSentences < maxSentences);
        assert (minSentences > 0);
        int count = this.random(minSentences, maxSentences);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                builder.append(' ');
            }
            builder.append(this.wordList(minWords, maxWords, true));
        }
        return builder.toString();
    }
}

