/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixValue;
import org.apache.sysml.runtime.util.UtilFunctions;

public class TripleIndexes
implements WritableComparable<TripleIndexes>,
Serializable {
    private static final long serialVersionUID = -4514135024726916288L;
    private long first = -1L;
    private long second = -1L;
    private long third = -1L;

    public TripleIndexes() {
    }

    public TripleIndexes(long i1, long i2, long i3) {
        this.first = i1;
        this.second = i2;
        this.third = i3;
    }

    public TripleIndexes(TripleIndexes that) {
        this.setIndexes(that);
    }

    public void setIndexes(TripleIndexes that) {
        this.first = that.first;
        this.second = that.second;
        this.third = that.third;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ") k: " + this.third;
    }

    public long getFirstIndex() {
        return this.first;
    }

    public long getSecondIndex() {
        return this.second;
    }

    public long getThirdIndex() {
        return this.third;
    }

    public void setIndexes(long i1, long i2, long i3) {
        this.first = i1;
        this.second = i2;
        this.third = i3;
    }

    public void readFields(DataInput in) throws IOException {
        this.first = in.readLong();
        this.second = in.readLong();
        this.third = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.first);
        out.writeLong(this.second);
        out.writeLong(this.third);
    }

    public int compareTo(TripleIndexes other) {
        if (this.first != other.first) {
            return this.first > other.first ? 1 : -1;
        }
        if (this.second != other.second) {
            return this.second > other.second ? 1 : -1;
        }
        if (this.third != other.third) {
            return this.third > other.third ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TripleIndexes)) {
            return false;
        }
        TripleIndexes tother = (TripleIndexes)other;
        return this.first == tother.first && this.second == tother.second && this.third == tother.third;
    }

    public int hashCode() {
        return UtilFunctions.longHashCode(this.first, this.second, this.third);
    }

    public static class FirstTwoIndexesPartitioner
    implements Partitioner<TripleIndexes, TaggedMatrixValue> {
        public int getPartition(TripleIndexes key, TaggedMatrixValue value, int numPartitions) {
            return UtilFunctions.longHashCode(key.getFirstIndex() * 127L + key.getSecondIndex() + 99991L) % 1405695061 % numPartitions;
        }

        public void configure(JobConf arg0) {
        }
    }

    public static class Comparator
    implements RawComparator<TripleIndexes> {
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return WritableComparator.compareBytes((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2);
        }

        public int compare(TripleIndexes m1, TripleIndexes m2) {
            return m1.compareTo(m2);
        }
    }
}

